/*
 * Decompiled with CFR 0.152.
 */
package me.alidg.errors.conf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.validation.MessageInterpolator;
import me.alidg.errors.ExceptionRefiner;
import me.alidg.errors.WebErrorHandler;
import me.alidg.errors.WebErrorHandlers;
import me.alidg.errors.adapter.DefaultHttpErrorAttributesAdapter;
import me.alidg.errors.adapter.HttpErrorAttributes;
import me.alidg.errors.adapter.HttpErrorAttributesAdapter;
import me.alidg.errors.handlers.AnnotatedWebErrorHandler;
import me.alidg.errors.handlers.SpringMvcWebErrorHandler;
import me.alidg.errors.handlers.SpringSecurityWebErrorHandler;
import me.alidg.errors.handlers.SpringValidationWebErrorHandler;
import me.alidg.errors.mvc.ErrorsControllerAdvice;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.context.MessageSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

@ConditionalOnWebApplication
@AutoConfigureAfter(value={MessageSourceAutoConfiguration.class, WebMvcAutoConfiguration.class})
public class ErrorsAutoConfiguration {
    private static final List<WebErrorHandler> BUILT_IN_HANDLERS = Arrays.asList(new SpringValidationWebErrorHandler(), new AnnotatedWebErrorHandler(), new SpringMvcWebErrorHandler());

    @Bean
    @ConditionalOnMissingBean
    public WebErrorHandlers webErrorHandlers(MessageSource messageSource, @Autowired(required=false) List<WebErrorHandler> customHandlers, @Qualifier(value="defaultWebErrorHandler") @Autowired(required=false) WebErrorHandler defaultWebErrorHandler, @Autowired(required=false) ExceptionRefiner exceptionRefiner) {
        ArrayList<WebErrorHandler> handlers = new ArrayList<WebErrorHandler>(BUILT_IN_HANDLERS);
        if (customHandlers != null && !customHandlers.isEmpty()) {
            customHandlers.remove(defaultWebErrorHandler);
            customHandlers.removeIf(Objects::isNull);
            customHandlers.sort((Comparator<WebErrorHandler>)AnnotationAwareOrderComparator.INSTANCE);
            handlers.addAll(customHandlers);
        }
        return new WebErrorHandlers(messageSource, handlers, defaultWebErrorHandler, exceptionRefiner);
    }

    @Bean
    @ConditionalOnBean(value={WebErrorHandlers.class})
    public ErrorsControllerAdvice errorsControllerAdvice(WebErrorHandlers webErrorHandlers, HttpErrorAttributesAdapter httpErrorAttributesAdapter) {
        return new ErrorsControllerAdvice(webErrorHandlers, httpErrorAttributesAdapter){};
    }

    @Bean(value={"mvcValidator", "defaultValidator"})
    @ConditionalOnBean(value={WebErrorHandlers.class})
    public Validator validator() {
        LocalValidatorFactoryBean factoryBean = new LocalValidatorFactoryBean();
        factoryBean.setMessageInterpolator((MessageInterpolator)new NoOpMessageInterpolator());
        return factoryBean;
    }

    @Bean
    @ConditionalOnBean(value={WebErrorHandlers.class})
    @ConditionalOnMissingBean(value={HttpErrorAttributesAdapter.class})
    public HttpErrorAttributesAdapter httpErrorAttributesAdapter() {
        return new DefaultHttpErrorAttributesAdapter();
    }

    @Bean
    @ConditionalOnBean(value={WebErrorHandlers.class})
    public ErrorAttributes errorAttributes(WebErrorHandlers webErrorHandlers, HttpErrorAttributesAdapter httpErrorAttributesAdapter) {
        return new HttpErrorAttributes(webErrorHandlers, httpErrorAttributesAdapter);
    }

    @Bean
    @ConditionalOnBean(value={WebErrorHandlers.class})
    @ConditionalOnClass(name={"org.springframework.security.access.AccessDeniedException"})
    public SpringSecurityWebErrorHandler springSecurityWebErrorHandler() {
        return new SpringSecurityWebErrorHandler();
    }

    private static class NoOpMessageInterpolator
    implements MessageInterpolator {
        private NoOpMessageInterpolator() {
        }

        public String interpolate(String messageTemplate, MessageInterpolator.Context context) {
            return messageTemplate;
        }

        public String interpolate(String messageTemplate, MessageInterpolator.Context context, Locale locale) {
            return messageTemplate;
        }
    }
}

