/*
 * Decompiled with CFR 0.152.
 */
package me.alidg.errors.adapter;

import java.util.Map;
import java.util.Objects;
import me.alidg.errors.HttpError;
import me.alidg.errors.WebErrorHandlers;
import me.alidg.errors.adapter.HttpErrorAttributesAdapter;
import me.alidg.errors.annotation.ExceptionMapping;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.NoHandlerFoundException;

public class HttpErrorAttributes
extends DefaultErrorAttributes {
    private static final String STATUS_CODE_ATTR = "javax.servlet.error.status_code";
    private final WebErrorHandlers webErrorHandlers;
    private final HttpErrorAttributesAdapter httpErrorAttributesAdapter;

    public HttpErrorAttributes(WebErrorHandlers webErrorHandlers, HttpErrorAttributesAdapter httpErrorAttributesAdapter) {
        Objects.requireNonNull(webErrorHandlers, "Web error handlers is required");
        Objects.requireNonNull(httpErrorAttributesAdapter, "Adapter is required");
        this.webErrorHandlers = webErrorHandlers;
        this.httpErrorAttributesAdapter = httpErrorAttributesAdapter;
    }

    public Map<String, Object> getErrorAttributes(WebRequest webRequest, boolean includeStackTrace) {
        Map attributes = super.getErrorAttributes(webRequest, includeStackTrace);
        Throwable exception = this.getError(webRequest);
        if (exception == null) {
            switch (this.getStatusCode(attributes)) {
                case 401: {
                    exception = new UnauthorizedException();
                    break;
                }
                case 403: {
                    exception = new ForbiddenException();
                    break;
                }
                case 404: {
                    exception = new NoHandlerFoundException("", this.getPath(attributes), HttpHeaders.EMPTY);
                    break;
                }
                default: {
                    exception = new IllegalStateException("The exception is null: " + attributes);
                }
            }
        }
        HttpError httpError = this.webErrorHandlers.handle(exception, webRequest.getLocale());
        this.saveStatusCodeInRequest(webRequest, httpError);
        return this.httpErrorAttributesAdapter.adapt(httpError);
    }

    private void saveStatusCodeInRequest(WebRequest webRequest, HttpError httpError) {
        int statusCode = httpError.getHttpStatus().value();
        webRequest.setAttribute(STATUS_CODE_ATTR, (Object)statusCode, 0);
    }

    private int getStatusCode(Map<String, Object> attributes) {
        try {
            return (Integer)attributes.getOrDefault("status", 0);
        }
        catch (Exception e) {
            return 0;
        }
    }

    private String getPath(Map<String, Object> attributes) {
        try {
            return (String)attributes.getOrDefault("path", "N/A");
        }
        catch (Exception e) {
            return "N/A";
        }
    }

    @ExceptionMapping(statusCode=HttpStatus.FORBIDDEN, errorCode="security.access_denied")
    private static final class ForbiddenException
    extends RuntimeException {
        private ForbiddenException() {
        }
    }

    @ExceptionMapping(statusCode=HttpStatus.UNAUTHORIZED, errorCode="security.auth_required")
    private static final class UnauthorizedException
    extends RuntimeException {
        private UnauthorizedException() {
        }
    }
}

