/*
 * Decompiled with CFR 0.152.
 */
package me.alidg.errors.handlers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.alidg.errors.HandledException;
import me.alidg.errors.WebErrorHandler;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;

public class SpringValidationWebErrorHandler
implements WebErrorHandler {
    @Override
    public boolean canHandle(Throwable exception) {
        return exception instanceof MethodArgumentNotValidException || exception instanceof BindException;
    }

    @Override
    public HandledException handle(Throwable exception) {
        BindingResult bindingResult = this.getBindingResult(exception);
        return bindingResult.getAllErrors().stream().collect(Collectors.collectingAndThen(Collectors.toMap(this::errorCode, this::arguments), m -> new HandledException(m.keySet(), HttpStatus.BAD_REQUEST, this.dropEmptyValues((Map<String, List<Object>>)m))));
    }

    private BindingResult getBindingResult(Throwable exception) {
        return exception instanceof BindException ? ((BindException)exception).getBindingResult() : ((MethodArgumentNotValidException)exception).getBindingResult();
    }

    private String errorCode(ObjectError error) {
        String message = error.getDefaultMessage() == null ? "" : error.getDefaultMessage();
        return message.replace("{", "").replace("}", "");
    }

    private List<Object> arguments(ObjectError error) {
        Object[] args = error.getArguments();
        return args == null || args.length <= 1 ? Collections.emptyList() : Arrays.asList(Arrays.copyOfRange(args, 1, args.length));
    }

    private Map<String, List<?>> dropEmptyValues(Map<String, List<Object>> input) {
        return input.entrySet().stream().filter(e -> e.getValue() != null && !((List)e.getValue()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

