/*
 * Decompiled with CFR 0.152.
 */
package kr.pe.kwonnam.underscore.stringbuilder.transformers;

import java.util.Iterator;
import kr.pe.kwonnam.underscore.stringbuilder.UnderscoreTransformer;

public class UnderscoreJoinTransformer
implements UnderscoreTransformer<CharSequence> {
    private Iterable<?> iterable;
    private Object[] objectArray;
    private String nullValue;

    public UnderscoreJoinTransformer(Iterable<?> iterable, String nullValue) {
        this.iterable = iterable;
        this.nullValue = this.refineNullValue(nullValue);
    }

    private String refineNullValue(String nullValue) {
        return nullValue == null ? "" : nullValue;
    }

    public UnderscoreJoinTransformer(Object[] objects, String nullValue) {
        this.objectArray = objects;
        this.nullValue = this.refineNullValue(nullValue);
    }

    @Override
    public CharSequence transform(CharSequence appendee) {
        CharSequence separator;
        CharSequence charSequence = separator = appendee == null ? "" : appendee;
        if (this.iterable != null) {
            return this.joinIterable(separator);
        }
        if (this.objectArray != null) {
            return this.joinArray(separator);
        }
        return "";
    }

    private CharSequence joinIterable(CharSequence separator) {
        Iterator<?> iterator = this.iterable.iterator();
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            stringBuilder.append((Object)(value == null ? this.nullValue : value));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(separator);
        }
        return stringBuilder.toString();
    }

    private CharSequence joinArray(CharSequence separator) {
        int arrayLength = this.objectArray.length;
        if (arrayLength == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < arrayLength; ++i) {
            if (i > 0) {
                stringBuilder.append(separator);
            }
            stringBuilder.append(this.objectArray[i] == null ? this.nullValue : this.objectArray[i]);
        }
        return stringBuilder.toString();
    }
}

