/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.flow.subscriber;

import java.util.function.Consumer;
import java.util.function.Function;
import kr.jm.utils.flow.subscriber.JMFileSubscriber;
import kr.jm.utils.flow.subscriber.JMSubscriber;
import kr.jm.utils.helper.JMJson;

public class JMSubscriberBuilder {
    public static <I> JMSubscriber<I> getSOPLSubscriber() {
        return JMSubscriberBuilder.getSOPLSubscriber(Function.identity());
    }

    public static <I> JMSubscriber<I> getJsonStringSOPLSubscriber() {
        return JMSubscriberBuilder.getJsonStringSOPLSubscriber(Function.identity());
    }

    public static <I> JMSubscriber<I> getSOPLSubscriber(Function<I, ?> transformFunction) {
        return JMSubscriberBuilder.build(o -> System.out.println(transformFunction.apply(o)));
    }

    public static <I> JMSubscriber<I> getJsonStringSOPLSubscriber(Function<I, ?> transformFunction) {
        return JMSubscriberBuilder.getSOPLSubscriber(o -> JMJson.toJsonString(transformFunction.apply(o)));
    }

    public static <I> JMFileSubscriber<I> getFileSubscriber(String filePath) {
        return new JMFileSubscriber(filePath);
    }

    public static <I> JMFileSubscriber<I> buildJsonStringFileSubscriber(String filePath) {
        return new JMFileSubscriber(filePath, true);
    }

    public static <I> JMFileSubscriber<I> buildJsonStringFileSubscriber(String filePath, Function<Object, String> toStringFunction) {
        return new JMFileSubscriber(filePath, toStringFunction);
    }

    public static <I> JMSubscriber<I> build(Consumer<I> itemConsumer) {
        return new JMSubscriber<I>(itemConsumer);
    }
}

