/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.flow.publisher;

import java.io.File;
import java.util.Collection;
import java.util.stream.Stream;
import kr.jm.utils.flow.publisher.JMSubmissionPublisher;
import kr.jm.utils.helper.JMFiles;
import kr.jm.utils.helper.JMOptional;
import kr.jm.utils.helper.JMPath;
import kr.jm.utils.helper.JMResources;

public class LineSubmissionPublisher
extends JMSubmissionPublisher<String> {
    public int submitFilePath(String filePath) {
        return this.submitFile(JMPath.getPath((String)filePath).toFile());
    }

    public int submitFile(File file) {
        return this.submitStream(JMFiles.readLines((File)file).stream());
    }

    public int submitStream(Stream<String> stream) {
        return stream.mapToInt(this::submit).sum();
    }

    public int submitClasspath(String resourceClasspath) {
        return this.submitStream(JMResources.readLines((String)resourceClasspath).stream());
    }

    public int submitFilePathOrClasspath(String filePathOrResourceClasspath) {
        return this.submitStream(JMOptional.getOptional((Collection)JMFiles.readLines((String)filePathOrResourceClasspath)).orElseGet(() -> JMResources.readLines((String)filePathOrResourceClasspath)).stream());
    }
}

