/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.flow.publisher;

import java.util.concurrent.Flow;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.SubmissionPublisher;
import kr.jm.utils.exception.JMExceptionManager;
import kr.jm.utils.flow.publisher.JMPublisherInterface;
import kr.jm.utils.helper.JMLog;
import kr.jm.utils.helper.JMThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSubmissionPublisher<T>
extends SubmissionPublisher<T>
implements JMPublisherInterface<T> {
    private int publishers;
    private int maxBufferCapacity;
    private long waitingMillis;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public JMSubmissionPublisher(int publishers, int maxBufferCapacity, long waitingMillis) {
        super(publishers > 0 ? JMThread.newThreadPool((int)publishers) : ForkJoinPool.commonPool(), maxBufferCapacity);
        this.publishers = publishers;
        this.maxBufferCapacity = maxBufferCapacity;
        this.waitingMillis = waitingMillis;
    }

    public JMSubmissionPublisher(int publishers, int maxBufferCapacity) {
        this(publishers, maxBufferCapacity, 0L);
    }

    public JMSubmissionPublisher(int publishers) {
        this(publishers, Flow.defaultBufferSize());
    }

    public JMSubmissionPublisher() {
        this(0);
    }

    @Override
    public int submit(T item) {
        JMLog.debug((Logger)this.log, (String)"submit", (Object[])new Object[]{item});
        try {
            return this.waiting(super.submit(item));
        }
        catch (Exception e) {
            return (Integer)JMExceptionManager.handleExceptionAndReturn((Logger)this.log, (Throwable)e, (String)"submit", () -> 0, (Object[])new Object[]{item});
        }
    }

    private int waiting(int rag) throws InterruptedException {
        if (rag >= this.maxBufferCapacity) {
            JMLog.warn((Logger)this.log, (String)"waiting", (Object[])new Object[]{this.waitingMillis});
            Thread.sleep(this.waitingMillis);
        }
        return rag;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        JMLog.debug((Logger)this.log, (String)"subscribe", (Object[])new Object[]{subscriber});
        super.subscribe(subscriber);
    }

    public String toString() {
        return "JMSubmissionPublisher{publishers=" + this.publishers + ", maxBufferCapacity=" + this.maxBufferCapacity + ", waitingMillis=" + this.waitingMillis + "}";
    }
}

