/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.flow.processor;

import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import kr.jm.utils.flow.processor.JMProcessor;
import kr.jm.utils.helper.JMLog;
import kr.jm.utils.helper.JMThread;
import org.slf4j.Logger;

public class JMConcurrentProcessor<T, R>
extends JMProcessor<T, R> {
    private ExecutorService executorService;

    public JMConcurrentProcessor(int workers, Function<T, R> transformerFunction) {
        super(transformerFunction);
        this.executorService = JMThread.newThreadPool((int)workers);
    }

    @Override
    protected void process(T input) {
        this.executorService.submit(() -> super.process(input));
    }

    @Override
    public void close() {
        JMLog.info((Logger)this.log, (String)"close");
        JMThread.awaitTermination((ExecutorService)this.executorService, (long)3000L);
        super.close();
    }
}

