/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.flow.processor;

import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.function.Function;
import kr.jm.utils.flow.processor.JMConcurrentTransformProcessor;
import kr.jm.utils.flow.processor.JMTransformProcessor;
import kr.jm.utils.flow.processor.JMTransformProcessorInterface;

public class JMTransformProcessorBuilder {
    public static <I, R> JMConcurrentTransformProcessor<Collection<I>, R> buildCollectionEachWithThreadPool(Function<Collection<I>, R> collectionTransformFunction) {
        return JMTransformProcessorBuilder.buildCollectionEachWithThreadPool(Flow.defaultBufferSize(), collectionTransformFunction);
    }

    public static <I, R> JMConcurrentTransformProcessor<Collection<I>, R> buildCollectionEachWithThreadPool(int maxBufferCapacity, Function<Collection<I>, R> collectionTransformFunction) {
        return JMTransformProcessorBuilder.buildCollectionEachWithThreadPool(null, maxBufferCapacity, collectionTransformFunction);
    }

    public static <I, R> JMConcurrentTransformProcessor<Collection<I>, R> buildCollectionEachWithThreadPool(Executor executor, int maxBufferCapacity, Function<Collection<I>, R> collectionTransformFunction) {
        return JMTransformProcessorBuilder.buildWithThreadPool(executor, maxBufferCapacity, collectionTransformFunction);
    }

    public static <I, O> JMTransformProcessor<I, O> build(Function<I, O> transformerFunction) {
        return new JMTransformProcessor<I, O>(transformerFunction);
    }

    public static <I, O> JMConcurrentTransformProcessor<I, O> buildWithThreadPool(Function<I, O> transformerFunction) {
        return JMTransformProcessorBuilder.buildWithThreadPool(Flow.defaultBufferSize(), transformerFunction);
    }

    public static <I, O> JMConcurrentTransformProcessor<I, O> buildWithThreadPool(int maxBufferCapacity, Function<I, O> transformerFunction) {
        return JMTransformProcessorBuilder.buildWithThreadPool(null, maxBufferCapacity, transformerFunction);
    }

    public static <I, O> JMConcurrentTransformProcessor<I, O> buildWithThreadPool(Executor executor, int maxBufferCapacity, Function<I, O> transformerFunction) {
        return new JMConcurrentTransformProcessor<I, O>(executor, maxBufferCapacity, transformerFunction);
    }

    public static <T, M, R> JMTransformProcessorInterface<T, R> buildCombine(Function<T, M> transformerFunction1, Function<M, R> transformerFunction2) {
        return JMTransformProcessorBuilder.build(t -> transformerFunction2.apply(transformerFunction1.apply(t)));
    }
}

