/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.flow.processor;

import java.util.Optional;
import java.util.concurrent.Flow;
import java.util.function.Function;
import kr.jm.utils.exception.JMExceptionManager;
import kr.jm.utils.flow.processor.JMTransformProcessorInterface;
import kr.jm.utils.flow.publisher.JMSubmissionPublisher;
import kr.jm.utils.flow.subscriber.JMSubscriber;
import kr.jm.utils.flow.subscriber.JMSubscriberBuilder;
import kr.jm.utils.helper.JMLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMTransformProcessor<T, R>
implements JMTransformProcessorInterface<T, R> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private JMSubscriber<T> inputSubscriber;
    private JMSubmissionPublisher<R> outputPublisher = new JMSubmissionPublisher();

    public JMTransformProcessor(Function<T, R> transformFunction) {
        this.inputSubscriber = JMSubscriberBuilder.build(t -> Optional.ofNullable(this.verifyTransformFunction(transformFunction, t)).ifPresent(this.outputPublisher::submit));
    }

    private <I, O> O verifyTransformFunction(Function<I, O> transformFunction, I i) {
        try {
            return transformFunction.apply(i);
        }
        catch (Exception e) {
            return (O)JMExceptionManager.handleExceptionAndReturnNull((Logger)this.log, (Throwable)e, (String)"verifyTransformFunction", (Object[])new Object[]{i});
        }
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        JMLog.info((Logger)this.log, (String)"onSubscribe", (Object[])new Object[]{subscription});
        this.inputSubscriber.onSubscribe(subscription);
    }

    @Override
    public void onNext(T item) {
        JMLog.debug((Logger)this.log, (String)"onNext", (Object[])new Object[]{item});
        this.inputSubscriber.onNext(item);
    }

    @Override
    public void onError(Throwable throwable) {
        this.inputSubscriber.onError(throwable);
    }

    @Override
    public void onComplete() {
        JMLog.info((Logger)this.log, (String)"onComplete");
        this.inputSubscriber.onComplete();
    }

    @Override
    public void subscribe(Flow.Subscriber<? super R> subscriber) {
        JMLog.info((Logger)this.log, (String)"subscribe", (Object[])new Object[]{subscriber});
        this.outputPublisher.subscribe(subscriber);
    }
}

