/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.flow.publisher;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Flow;
import java.util.function.Supplier;
import kr.jm.utils.flow.publisher.WaitingSubmissionPublisher;
import kr.jm.utils.helper.JMLog;
import kr.jm.utils.helper.JMThread;
import org.slf4j.Logger;

public class WaitingSubmissionPublisherDemon<T>
extends WaitingSubmissionPublisher<T> {
    private ExecutorService executorService = JMThread.newSingleThreadPool();
    private Supplier<T> dataSupplier;

    public WaitingSubmissionPublisherDemon(Supplier<T> dataSupplier) {
        this(null, dataSupplier);
    }

    public WaitingSubmissionPublisherDemon(int queueSizeLimit, Supplier<T> dataSupplier) {
        this(null, queueSizeLimit, dataSupplier);
    }

    public WaitingSubmissionPublisherDemon(ExecutorService executorService, Supplier<T> dataSupplier) {
        this(executorService, Flow.defaultBufferSize(), dataSupplier);
    }

    public WaitingSubmissionPublisherDemon(ExecutorService executorService, int queueSizeLimit, Supplier<T> dataSupplier) {
        super(executorService, queueSizeLimit);
        this.dataSupplier = dataSupplier;
    }

    public WaitingSubmissionPublisherDemon<T> start() {
        this.executorService = JMThread.startWithSingleExecutorService((String)"WaitingSubmissionPublisherDemon", this::run);
        return this;
    }

    private void run() {
        JMLog.info((Logger)this.log, (String)"run");
        while (!this.executorService.isShutdown()) {
            this.submit(JMThread.suspendWhenNull((long)100L, this.dataSupplier));
        }
    }

    @Override
    public void close() {
        JMLog.info((Logger)this.log, (String)"close");
        JMThread.shutdownNowAndWaitToBeTerminated((ExecutorService)this.executorService);
        super.close();
    }
}

