/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.flow.publisher;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import kr.jm.utils.flow.publisher.JMSubmissionPublisherInterface;
import kr.jm.utils.helper.JMLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSubmissionPublisher<T>
implements JMSubmissionPublisherInterface<T> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private SingleSubscription singleSubscription;
    private List<Flow.Subscriber<? super T>> subscriberList;

    public JMSubmissionPublisher() {
        this(() -> null);
    }

    public JMSubmissionPublisher(Supplier<T> inputSupplier) {
        this.singleSubscription = new SingleSubscription(inputSupplier);
        this.subscriberList = new ArrayList<Flow.Subscriber<? super T>>();
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        JMLog.info((Logger)this.log, (String)"subscribeWith", (Object[])new Object[]{subscriber});
        subscriber.onSubscribe(this.singleSubscription);
        this.subscriberList.add(subscriber);
    }

    @Override
    public int submit(T item) {
        JMLog.debug((Logger)this.log, (String)"submit", (Object[])new Object[]{item});
        if (Objects.isNull(item)) {
            return 0;
        }
        this.singleSubscription.next(item);
        return 1;
    }

    private class SingleSubscription
    implements Flow.Subscription {
        private Supplier<T> inputSupplier;
        private AtomicBoolean isCanceled;

        public SingleSubscription(Supplier<T> inputSupplier) {
            this.inputSupplier = inputSupplier;
            this.isCanceled = new AtomicBoolean(false);
        }

        @Override
        public void request(long n) {
            if (this.isNotCanceledOrNonNullSubscriber()) {
                int i = 0;
                while ((long)i < n) {
                    Optional.ofNullable(this.inputSupplier.get()).ifPresent(this::next);
                    ++i;
                }
            }
        }

        private boolean isNotCanceledOrNonNullSubscriber() {
            return !this.isCanceled() || this.nonNullSubscriber();
        }

        private boolean isCanceled() {
            boolean isCanceled = this.isCanceled.get();
            if (isCanceled) {
                JMSubmissionPublisher.this.log.warn("isCanceled = {} !!!", (Object)this.isCanceled);
            }
            return isCanceled;
        }

        @Override
        public void cancel() {
            JMLog.info((Logger)JMSubmissionPublisher.this.log, (String)"cancel");
            this.isCanceled.set(true);
        }

        private void next(T data) {
            if (this.isNotCanceledOrNonNullSubscriber() && this.nonNullData(data)) {
                for (Flow.Subscriber subscriber : JMSubmissionPublisher.this.subscriberList) {
                    subscriber.onNext(data);
                }
            }
        }

        private boolean nonNullData(T data) {
            return this.nonNullWithWarnLog("data", data);
        }

        private boolean nonNullSubscriber() {
            return this.nonNullWithWarnLog("subscriberList", JMSubmissionPublisher.this.subscriberList);
        }

        private boolean nonNullWithWarnLog(String targetName, Object target) {
            if (Objects.nonNull(target)) {
                return true;
            }
            JMSubmissionPublisher.this.log.warn("{} = null", (Object)targetName);
            return false;
        }
    }
}

