/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import kr.jm.utils.exception.JMExceptionManager;
import kr.jm.utils.helper.JMOptional;
import kr.jm.utils.helper.JMThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StdInLineConsumer
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(StdInLineConsumer.class);
    private ExecutorService executorService;
    private Consumer<String> stdInLineConsumer;

    public StdInLineConsumer(Consumer<String> stdInLineConsumer) {
        this.stdInLineConsumer = stdInLineConsumer;
    }

    public StdInLineConsumer consumeStdIn() {
        this.executorService = JMThread.newSingleThreadPool();
        JMThread.runAsync(this::startStdIn, this.executorService);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startStdIn() {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));){
            while (!this.executorService.isShutdown()) {
                JMOptional.getOptional(bufferedReader.readLine()).ifPresent(this.stdInLineConsumer);
            }
        }
        catch (Exception e) {
            JMExceptionManager.handleException(log, e, "startStdIn", new Object[0]);
        }
        finally {
            this.close();
        }
    }

    @Override
    public void close() {
        JMThread.awaitTermination(this.executorService);
    }
}

