/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.stats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import kr.jm.utils.stats.StatsField;

public class NumberSummaryStatistics {
    private final List<Number> numberList = Collections.synchronizedList(new ArrayList());
    private int oldSize = -1;
    private DoubleSummaryStatistics doubleSummaryStatistics;

    private NumberSummaryStatistics() {
    }

    public static NumberSummaryStatistics of() {
        return new NumberSummaryStatistics();
    }

    public static NumberSummaryStatistics of(Collection<Number> numberCollection) {
        return NumberSummaryStatistics.of().addAll(numberCollection);
    }

    public NumberSummaryStatistics addAll(Collection<Number> numberCollection) {
        this.numberList.addAll(numberCollection);
        return this;
    }

    public <N extends Number> NumberSummaryStatistics addAll(Stream<N> numberStream) {
        return this.addAll(numberStream.collect(Collectors.toList()));
    }

    public NumberSummaryStatistics addAll(int[] ints) {
        return this.addAll(IntStream.of(ints).boxed());
    }

    public NumberSummaryStatistics addAll(long[] longs) {
        return this.addAll(LongStream.of(longs).boxed());
    }

    public NumberSummaryStatistics addAll(double[] doubles) {
        return this.addAll(DoubleStream.of(doubles).boxed());
    }

    public DoubleSummaryStatistics getDoubleSummaryStatistics() {
        return this.getDoubleSummaryStatistics(this.numberList.size());
    }

    private DoubleSummaryStatistics getDoubleSummaryStatistics(int size) {
        return this.oldSize != size ? this.initDoubleSummaryStatistics(size) : this.doubleSummaryStatistics;
    }

    private DoubleSummaryStatistics initDoubleSummaryStatistics(int size) {
        this.oldSize = size;
        this.doubleSummaryStatistics = this.getDoubleStream().summaryStatistics();
        return this.doubleSummaryStatistics;
    }

    private DoubleStream getDoubleStream() {
        return this.numberList.stream().mapToDouble(Number::doubleValue);
    }

    public Number getSum() {
        return this.getDoubleSummaryStatistics().getSum();
    }

    public Number getMin() {
        return this.getDoubleSummaryStatistics().getMin();
    }

    public Number getMax() {
        return this.getDoubleSummaryStatistics().getMax();
    }

    public Number getAverage() {
        return this.getDoubleSummaryStatistics().getAverage();
    }

    public Number getCount() {
        return this.getDoubleSummaryStatistics().getCount();
    }

    public List<Number> getNumberList() {
        return Collections.unmodifiableList(this.numberList);
    }

    public NumberSummaryStatistics combine(NumberSummaryStatistics other) {
        return this.addAll(other.numberList);
    }

    public Number getStats(StatsField statsField) {
        return statsField.calStats(this.getDoubleSummaryStatistics());
    }

    public Number getStats(String statsFieldString) {
        return this.getStats(StatsField.valueOf(statsFieldString));
    }

    public String toString() {
        return String.format("%s{count=%d, sum=%f, min=%f, max=%f, average=%f}", this.getClass().getSimpleName(), this.getCount().longValue(), this.getSum().doubleValue(), this.getMin().doubleValue(), this.getMax().doubleValue(), this.getAverage().doubleValue());
    }

    public Map<StatsField, Number> getStatsFieldMap() {
        return Arrays.stream(StatsField.values()).collect(Collectors.toMap(Function.identity(), this::getStats));
    }
}

