/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.helper;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kr.jm.utils.helper.JMLambda;

public class JMPredicate {
    public static <T> Predicate<T> getTrue() {
        return target -> Boolean.TRUE;
    }

    public static <T> Predicate<T> getFalse() {
        return target -> Boolean.FALSE;
    }

    public static <T> Predicate<T> getBoolean(boolean bool) {
        return target -> bool;
    }

    public static Predicate<Number> getGreater(Number target) {
        return number -> number.doubleValue() > target.doubleValue();
    }

    public static Predicate<Number> getGreaterOrEqual(Number target) {
        return number -> number.doubleValue() >= target.doubleValue();
    }

    public static Predicate<Number> getLess(Number target) {
        return number -> number.doubleValue() < target.doubleValue();
    }

    public static Predicate<Number> getLessOrEqual(Number target) {
        return number -> number.doubleValue() <= target.doubleValue();
    }

    public static Predicate<Collection<?>> getGreaterSize(int target) {
        return collection -> collection.size() > target;
    }

    public static Predicate<Map<?, ?>> getGreaterMapSize(int target) {
        return map -> map.size() > target;
    }

    public static Predicate<Object[]> getGreaterLength(int target) {
        return array -> ((Object[])array).length > target;
    }

    public static Predicate<Collection<?>> getGreaterOrEqualSize(int target) {
        return collection -> collection.size() >= target;
    }

    public static Predicate<Map<?, ?>> getGreaterMapOrEqualSize(int target) {
        return map -> map.size() > target;
    }

    public static Predicate<Object[]> getGreaterOrEqualLength(int target) {
        return array -> ((Object[])array).length >= target;
    }

    public static Predicate<Collection<?>> getLessSize(int target) {
        return collection -> collection.size() < target;
    }

    public static Predicate<Map<?, ?>> getLessMapSize(int target) {
        return map -> map.size() < target;
    }

    public static Predicate<Object[]> getLessLength(int target) {
        return array -> ((Object[])array).length < target;
    }

    public static Predicate<Collection<?>> getLessOrEqualSize(int target) {
        return collection -> collection.size() <= target;
    }

    public static Predicate<Map<?, ?>> getLessMapOrEqualSize(int target) {
        return map -> map.size() <= target;
    }

    public static Predicate<Object[]> getLessOrEqualLength(int target) {
        return array -> ((Object[])array).length <= target;
    }

    public static Predicate<Collection<?>> getEqualSize(int target) {
        return collection -> collection.size() == target;
    }

    public static Predicate<String> getContains(CharSequence target) {
        return string -> string.contains(target);
    }

    public static Predicate<String> getIsEmpty() {
        return String::isEmpty;
    }

    public static Predicate<String> getEndsWith(String suffix) {
        return string -> string.endsWith(suffix);
    }

    public static Predicate<String> getStartsWith(String prefix) {
        return string -> string.startsWith(prefix);
    }

    public static Predicate<String> getMatches(String regex) {
        return string -> string.matches(regex);
    }

    public static <T> Predicate<T> getIsNull() {
        return Objects::isNull;
    }

    public static <T> Predicate<T> getIsNotNull() {
        return Objects::nonNull;
    }

    public static <T> Predicate<T> peekToRun(Runnable block) {
        return target -> JMLambda.getTrueAfterRunning(block);
    }

    public static <T> Predicate<T> peek(Consumer<T> consumer) {
        return target -> JMLambda.getTrueAfterRunning(() -> consumer.accept(target));
    }

    public static <T> Predicate<T> peekSOPL() {
        return target -> JMLambda.getTrueAfterRunning(() -> System.out.println(target));
    }

    public static <T> Predicate<T> getEquals(T target2) {
        return target -> target.equals(target2);
    }

    public static <T> Predicate<T> negate(Predicate<T> predicate) {
        return predicate.negate();
    }

    public static <T> Predicate<T> negate(boolean bool) {
        return target -> !bool;
    }
}

