/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.helper;

import java.util.Arrays;
import java.util.Collection;
import kr.jm.utils.AutoStringBuilder;
import org.slf4j.Logger;

public class JMLog {
    public static void info(Logger log, String methodName) {
        if (log.isInfoEnabled()) {
            log.info(JMLog.buildMethodLogString(methodName));
        }
    }

    public static void info(Logger log, String methodName, Object ... params) {
        if (log.isInfoEnabled()) {
            log.info(JMLog.buildMethodLogString(methodName, params));
        }
    }

    public static void infoAndDebug(Logger log, String methodName, Object ... params) {
        if (!log.isInfoEnabled()) {
            return;
        }
        int length = params.length;
        Object[] newParams = new Object[length];
        boolean hasCollection = false;
        for (int i = 0; i < length; ++i) {
            if (params[i] instanceof Collection) {
                newParams[i] = ((Collection)params[i]).size();
                hasCollection = true;
                continue;
            }
            newParams[i] = params[i];
        }
        if (hasCollection) {
            log.info(JMLog.buildMethodLogString(methodName, newParams));
        }
        log.debug(JMLog.buildMethodLogString(methodName, params));
    }

    public static void error(Logger log, String methodName) {
        log.error(JMLog.buildMethodLogString(methodName));
    }

    public static void error(Logger log, String methodName, Object ... params) {
        log.error(JMLog.buildMethodLogString(methodName, params));
    }

    public static void errorForException(Logger log, Throwable throwable, String methodName) {
        log.error(JMLog.buildMethodLogString(methodName), throwable);
    }

    public static void errorForException(Logger log, Throwable throwable, String methodName, Object ... params) {
        log.error(JMLog.buildMethodLogString(methodName, params), throwable);
    }

    private static String buildMethodLogString(String methodName) {
        return methodName + "()";
    }

    private static String buildMethodLogString(String methodName, Object[] params) {
        AutoStringBuilder loggerASB = new AutoStringBuilder(", ");
        loggerASB.getStringBuilder().append(methodName).append("(");
        for (Object param : params) {
            loggerASB.append(param == null ? "null" : (param.getClass().isArray() ? Arrays.toString((Object[])param) : param.toString()));
        }
        return loggerASB.removeLastAutoAppendingString().getStringBuilder().append(")").toString();
    }

    public static void debug(Logger log, String methodName, Object ... params) {
        if (log.isDebugEnabled()) {
            log.debug(JMLog.buildMethodLogString(methodName, params));
        }
    }

    public static void debug(Logger log, String methodName) {
        if (log.isDebugEnabled()) {
            log.debug(JMLog.buildMethodLogString(methodName));
        }
    }

    public static void warn(Logger log, String methodName, Object ... params) {
        if (log.isWarnEnabled()) {
            log.warn(JMLog.buildMethodLogString(methodName, params));
        }
    }

    public static void warn(Logger log, String methodName) {
        if (log.isWarnEnabled()) {
            log.warn(JMLog.buildMethodLogString(methodName));
        }
    }
}

