/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.helper;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JMString {
    public static final String PIPE = "|";
    public static final String EMPTY = "";
    public static final String UNDERSCORE = "_";
    public static final String HYPHEN = "-";
    public static final String COLON = ":";
    public static final String SEMICOLON = ";";
    public static final String COMMA = ",";
    public static final String SPACE = " ";
    public static final String DOT = ".";
    public static final String LINE_SEPARATOR = System.lineSeparator();
    public static final String IPV4Pattern = "(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])";
    public static final String IPV6Pattern = "([0-9a-f]{1,4}:){7}([0-9a-f]){1,4}";
    public static final String NumberPattern = "[+-]?\\d+(\\.\\d+)?";
    public static final String WordPattern = "\\S+";
    private static Pattern numberPattern;
    private static Pattern wordPattern;

    public static boolean isNumber(String numberString) {
        return Optional.ofNullable(numberPattern).orElseGet(() -> {
            numberPattern = Pattern.compile(NumberPattern);
            return numberPattern;
        }).matcher(numberString).matches();
    }

    public static boolean isWord(String wordString) {
        return Optional.ofNullable(wordPattern).orElseGet(() -> {
            wordPattern = Pattern.compile(WordPattern);
            return wordPattern;
        }).matcher(wordString).matches();
    }

    public static String joining(Stream<String> stringStream) {
        return stringStream.collect(Collectors.joining());
    }

    public static String joiningWith(Stream<String> stringStream, CharSequence delimiter) {
        return stringStream.collect(Collectors.joining(delimiter));
    }

    public static String joiningWithComma(List<String> stringList) {
        return JMString.joiningWithDelimiter((CharSequence)COMMA, stringList);
    }

    public static String joiningWithUnderscore(List<String> stringList) {
        return JMString.joiningWithDelimiter((CharSequence)UNDERSCORE, stringList);
    }

    public static String joiningWithSpace(List<String> stringList) {
        return JMString.joiningWithDelimiter((CharSequence)SPACE, stringList);
    }

    public static String joiningWithSemicolon(List<String> stringList) {
        return JMString.joiningWithDelimiter((CharSequence)SEMICOLON, stringList);
    }

    public static String joiningWithDot(List<String> stringList) {
        return JMString.joiningWithDelimiter((CharSequence)DOT, stringList);
    }

    public static String joiningWithPipe(List<String> stringList) {
        return JMString.joiningWithDelimiter((CharSequence)PIPE, stringList);
    }

    public static String joiningWithPipe(String ... strings) {
        return JMString.joiningWithDelimiter((CharSequence)PIPE, strings);
    }

    public static String joiningWithDot(String ... strings) {
        return JMString.joiningWithDelimiter((CharSequence)DOT, strings);
    }

    public static String joiningWithComma(String ... strings) {
        return JMString.joiningWithDelimiter((CharSequence)COMMA, strings);
    }

    public static String joiningWithUnderscore(String ... strings) {
        return JMString.joiningWithDelimiter((CharSequence)UNDERSCORE, strings);
    }

    public static String joiningWithSpace(String ... strings) {
        return JMString.joiningWithDelimiter((CharSequence)SPACE, strings);
    }

    public static String joiningWithSemicolon(String ... strings) {
        return JMString.joiningWithDelimiter((CharSequence)SEMICOLON, strings);
    }

    public static boolean isNotNullOrEmpty(String string) {
        return !JMString.isNullOrEmpty(string);
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || JMString.isEmpty(string);
    }

    public static boolean isEmpty(String string) {
        return EMPTY.equals(string);
    }

    public static String joining(String ... strings) {
        return JMString.joining(Arrays.stream(strings));
    }

    public static String joiningWithDelimiter(CharSequence delimiter, String ... strings) {
        return JMString.joiningWith(Arrays.stream(strings), delimiter);
    }

    public static String joiningWithDelimiter(CharSequence delimiter, List<String> stringList) {
        return JMString.joiningWith(stringList.stream(), delimiter);
    }

    public static String[] splitFileNameIntoPreSuffix(String fileName) {
        String[] preSuffix = new String[]{fileName, EMPTY};
        int dotIndex = fileName.lastIndexOf(DOT);
        if (dotIndex > 0) {
            preSuffix[0] = fileName.substring(0, dotIndex);
            preSuffix[1] = fileName.substring(dotIndex);
        }
        return preSuffix;
    }

    public static String getPrefixOfFileName(String fileName) {
        int dotIndex = fileName.lastIndexOf(DOT);
        return dotIndex > 0 ? fileName.substring(0, dotIndex) : fileName;
    }

    public static String getExtension(String fileName) {
        int dotIndex = fileName.lastIndexOf(DOT);
        return dotIndex > 0 ? fileName.substring(dotIndex) : EMPTY;
    }

    public static String truncate(String string, int maxBytesLength) {
        byte[] stringBytes = string.getBytes();
        return stringBytes.length > maxBytesLength ? new String(stringBytes, 0, maxBytesLength - 1) : string;
    }

    public static String truncate(String string, int maxBytesLength, String appendString) {
        return string.getBytes().length > maxBytesLength ? JMString.truncate(string, maxBytesLength - appendString.getBytes().length) + appendString : string;
    }

    public static String buildIpOrHostnamePortPair(String ipOrHostname, int port) {
        return ipOrHostname + COLON + port;
    }

    public static String roundedNumberFormat(Double number, int decimalPoint) {
        return String.format("%." + decimalPoint + "f", number);
    }
}

