/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kr.jm.utils.datastructure.JMMap;
import kr.jm.utils.exception.JMExceptionManager;
import kr.jm.utils.helper.JMLambda;
import kr.jm.utils.helper.JMStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexAliasMap<V>
implements Map<String, V> {
    private static final Logger log = LoggerFactory.getLogger(IndexAliasMap.class);
    private final List<V> dataList;
    private Map<String, Integer> aliasIndexMap;

    public IndexAliasMap(List<V> dataList) {
        this(null, dataList);
    }

    public IndexAliasMap(List<String> aliasList, List<V> dataList) {
        this.dataList = new ArrayList<V>(dataList);
        this.aliasIndexMap = new HashMap<String, Integer>(this.size());
        if (aliasList != null) {
            this.addAllWithAlias(aliasList, dataList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllWithAlias(List<String> aliasList, List<V> dataList) {
        List<V> list = dataList;
        synchronized (list) {
            JMLambda.runByBoolean(aliasList.size() == dataList.size(), () -> JMStream.numberRangeWithCount(0, 1, dataList.size()).forEach((int i) -> this.addWithAlias((String)aliasList.get(i), dataList.get(i))), () -> JMExceptionManager.logRuntimeException(log, "Wrong Key List Size !!! - dataList Size = " + this.size() + " aliasList Size = " + aliasList.size(), "setKeyIndexMap", aliasList));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer addWithAlias(String alias, V value) {
        List<V> list = this.dataList;
        synchronized (list) {
            this.dataList.add(value);
            return this.aliasIndexMap.put(alias, this.dataList.size() - 1);
        }
    }

    public synchronized void putAlias(String alias, int index) {
        JMLambda.runByBoolean(index < this.size(), () -> this.aliasIndexMap.put(alias, index), () -> JMExceptionManager.logRuntimeException(log, "Wrong Index !!! - dataList Size = " + this.dataList, "setKeyIndexMap", index));
    }

    @Override
    public V put(String key, V value) {
        return this.dataList.get(this.addWithAlias(key, value));
    }

    public V get(int index) {
        return this.dataList.get(index);
    }

    @Override
    public int size() {
        return this.dataList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.dataList.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.aliasIndexMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.dataList.contains(value);
    }

    @Override
    public V get(Object key) {
        return this.dataList.get(this.aliasIndexMap.get(key));
    }

    @Override
    public V remove(Object key) {
        return this.dataList.remove(this.aliasIndexMap.remove(key));
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        ArrayList<String> keyList = new ArrayList<String>(m.keySet());
        this.addAllWithAlias(keyList, keyList.stream().map(m::get).collect(Collectors.toList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        List<V> list = this.dataList;
        synchronized (list) {
            this.dataList.clear();
            this.aliasIndexMap.clear();
        }
    }

    @Override
    public Set<String> keySet() {
        return this.aliasIndexMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return new ArrayList<V>(this.dataList);
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return JMMap.newChangedValueMap(this.aliasIndexMap, this.dataList::get).entrySet();
    }
}

