/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.helper;

import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kr.jm.utils.JMProgressiveManager;
import kr.jm.utils.datastructure.JMCollections;
import kr.jm.utils.exception.JMExceptionManager;
import kr.jm.utils.helper.JMFiles;
import kr.jm.utils.helper.JMLambda;
import kr.jm.utils.helper.JMLog;
import kr.jm.utils.helper.JMOptional;
import kr.jm.utils.helper.JMPath;
import kr.jm.utils.helper.JMPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMPathOperation {
    static final Logger log = LoggerFactory.getLogger(JMPathOperation.class);

    public static Path copy(Path sourcePath, Path destinationPath, CopyOption ... options) {
        return JMPathOperation.operate(sourcePath, destinationPath, "copy", finalPath -> {
            try {
                return Files.copy(sourcePath, finalPath, options);
            }
            catch (Exception e) {
                return (Path)JMExceptionManager.handleExceptionAndReturnNull(log, e, "copy", sourcePath, destinationPath, options);
            }
        });
    }

    public static Optional<JMProgressiveManager<Path, Path>> copyDirRecursivelyAsync(Path targetDirPath, Path destinationDirPath, CopyOption ... options) {
        Map<Boolean, List<Path>> directoryOrFilePathMap = JMLambda.groupBy(JMPath.getSubPathList(targetDirPath), JMPath::isDirectory);
        JMOptional.getOptional(directoryOrFilePathMap, true).ifPresent(list -> list.stream().map(dirPath -> JMPath.buildRelativeDestinationPath(destinationDirPath, targetDirPath, dirPath)).forEach(x$0 -> JMPathOperation.createDirectories(x$0, new FileAttribute[0])));
        return JMPathOperation.operateDir(targetDirPath, destinationDirPath, directoryOrFilePathMap.get(false), bulkPathList -> new JMProgressiveManager((Collection<Path>)bulkPathList, path -> Optional.ofNullable(JMPathOperation.copy(path, JMPath.buildRelativeDestinationPath(destinationDirPath, targetDirPath, path), options))));
    }

    public static Optional<JMProgressiveManager<Path, Path>> copyFilePathListAsync(List<Path> filePathList, Path destinationDirPath, CopyOption ... options) {
        return JMPathOperation.operateBulk(filePathList, destinationDirPath, sourcePath -> Optional.ofNullable(JMPathOperation.copy(sourcePath, destinationDirPath, options)));
    }

    public static Path move(Path sourcePath, Path destinationPath, CopyOption ... options) {
        return JMPathOperation.operate(sourcePath, destinationPath, "move", finalPath -> {
            try {
                return Files.move(sourcePath, finalPath, options);
            }
            catch (Exception e) {
                return (Path)JMExceptionManager.handleExceptionAndReturnNull(log, e, "move", sourcePath, destinationPath, options);
            }
        });
    }

    public static Optional<Path> moveDir(Path sourceDirPath, Path destinationDirPath, CopyOption ... options) {
        return JMPathOperation.operateDir(sourceDirPath, destinationDirPath, sourceDirPath, path -> JMPathOperation.move(path, destinationDirPath, options));
    }

    public static Optional<JMProgressiveManager<Path, Path>> movePathListAsync(List<Path> pathList, Path destinationDirPath, CopyOption ... options) {
        return JMPathOperation.operateBulk(pathList, destinationDirPath, sourcePath -> JMPath.isDirectory(sourcePath) ? JMPathOperation.moveDir(sourcePath, destinationDirPath, options) : Optional.ofNullable(JMPathOperation.move(sourcePath, destinationDirPath, options)));
    }

    private static Path operate(Path sourcePath, Path destinationPath, String method, Function<Path, Path> resultPathFunction) {
        Path finalPath;
        JMLog.debug(log, method, sourcePath, destinationPath);
        Path path = finalPath = JMPath.isDirectory(destinationPath) ? destinationPath.resolve(sourcePath.getFileName()) : JMPathOperation.buildParentAndDestinationPath(destinationPath);
        if (sourcePath.equals(finalPath)) {
            throw new RuntimeException("Already Exist !!!");
        }
        return resultPathFunction.apply(finalPath);
    }

    private static Path buildParentAndDestinationPath(Path destinationPath) {
        JMLambda.runIfTrue(!JMPath.exists(destinationPath.getParent()), () -> JMPathOperation.createDirectories(destinationPath.getParent(), new FileAttribute[0]));
        return destinationPath;
    }

    private static <T, R> Optional<R> operateDir(Path sourceDirPath, Path destinationDirPath, T target, Function<T, R> operateDirFunction) {
        if (!JMPath.exists(destinationDirPath)) {
            JMPathOperation.createDirectories(destinationDirPath, new FileAttribute[0]);
        }
        return JMLambda.functionIfTrue(JMPath.isDirectory(sourceDirPath) && JMPath.isDirectory(destinationDirPath), target, operateDirFunction);
    }

    private static Optional<JMProgressiveManager<Path, Path>> operateBulk(List<Path> bulkPathList, Path destinationDirPath, Function<Path, Optional<Path>> operationFunction) {
        JMLambda.runIfTrue(!JMPath.exists(destinationDirPath), () -> JMPathOperation.createDirectories(destinationDirPath, new FileAttribute[0]));
        return JMLambda.supplierIfTrue(JMPath.isDirectory(destinationDirPath), () -> new JMProgressiveManager(bulkPathList, operationFunction::apply));
    }

    public static boolean delete(Path targetPath) {
        JMLog.debug(log, "delete", targetPath);
        try {
            Files.delete(targetPath);
            return true;
        }
        catch (Exception e) {
            return JMExceptionManager.handleExceptionAndReturnFalse(log, e, "delete", targetPath);
        }
    }

    public static boolean deleteAll(Path targetPath) {
        JMLog.debug(log, "deleteAll", targetPath);
        return JMPath.isDirectory(targetPath) ? JMPathOperation.deleteDir(targetPath) : JMPathOperation.delete(targetPath);
    }

    public static boolean deleteDir(Path targetDirPath) {
        JMLog.debug(log, "deleteDir", targetDirPath);
        return JMPathOperation.deleteBulkThenFalseList(JMCollections.getReversed(JMPath.getSubPathList(targetDirPath))).size() == 0 && JMPathOperation.delete(targetDirPath);
    }

    public static List<Path> deleteBulkThenFalseList(List<Path> bulkPathList) {
        JMLog.debug(log, "deleteBulkThenFalseList", bulkPathList);
        return bulkPathList.stream().filter(JMPredicate.negate(JMPathOperation::deleteAll)).collect(Collectors.toList());
    }

    public static JMProgressiveManager<Path, Boolean> deleteAllAsync(List<Path> pathList) {
        JMLog.debug(log, "deleteAllAsync", pathList);
        return new JMProgressiveManager<Path, Boolean>(pathList, targetPath -> Optional.of(JMPathOperation.deleteAll(targetPath)));
    }

    public static Path deleteOnExit(Path path) {
        JMLog.debug(log, "deleteOnExit", path);
        path.toFile().deleteOnExit();
        return path;
    }

    public static Optional<Path> createTempFilePathAsOpt(Path path) {
        JMLog.debug(log, "createTempFilePathAsOpt", path);
        String[] prefixSuffix = JMFiles.getPrefixSuffix(path.toFile());
        try {
            return Optional.of(Files.createTempFile(prefixSuffix[0], prefixSuffix[1], new FileAttribute[0])).filter(JMPath.ExistFilter).map(JMPathOperation::deleteOnExit);
        }
        catch (Exception e) {
            return JMExceptionManager.handleExceptionAndReturnEmptyOptional(log, e, "createTempFilePathAsOpt", path);
        }
    }

    public static Optional<Path> createTempDirPathAsOpt(Path path) {
        JMLog.debug(log, "createTempDirPathAsOpt", path);
        try {
            return Optional.of(Files.createTempDirectory(path.toString(), new FileAttribute[0])).filter(JMPath.ExistFilter).map(JMPathOperation::deleteOnExit);
        }
        catch (Exception e) {
            return JMExceptionManager.handleExceptionAndReturnEmptyOptional(log, e, "createTempDirPathAsOpt", path);
        }
    }

    public static Optional<Path> createFile(Path path, FileAttribute<?> ... attrs) {
        JMLog.debug(log, "createFile", path, attrs);
        try {
            return Optional.of(Files.createFile(path, attrs));
        }
        catch (Exception e) {
            return JMExceptionManager.handleExceptionAndReturnEmptyOptional(log, e, "createFile", path);
        }
    }

    public static Optional<Path> createDirectories(Path dirPath, FileAttribute<?> ... attrs) {
        JMLog.debug(log, "createDirectories", dirPath, attrs);
        try {
            return Optional.of(Files.createDirectories(dirPath, attrs));
        }
        catch (Exception e) {
            return JMExceptionManager.handleExceptionAndReturnEmptyOptional(log, e, "createDirectories", dirPath);
        }
    }

    public static Optional<Path> createDirectory(Path dirPath, FileAttribute<?> ... attrs) {
        JMLog.debug(log, "createDirectory", dirPath, attrs);
        try {
            return Optional.of(Files.createDirectory(dirPath, attrs));
        }
        catch (Exception e) {
            return JMExceptionManager.handleExceptionAndReturnEmptyOptional(log, e, "createDirectory", dirPath);
        }
    }

    public static void createFileWithParentDirectories(Path path, FileAttribute<?> ... attrs) {
        JMPathOperation.createDirectories(path.getParent(), attrs);
        JMPathOperation.createFile(path, attrs);
    }

    public static boolean deleteDirOnExist(Path dirPath) {
        return JMPath.exists(dirPath) && JMPathOperation.deleteDir(dirPath);
    }
}

