/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.helper;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kr.jm.utils.helper.JMPredicate;

public class JMOptional {
    public static Optional<String> getOptional(String string) {
        return Optional.ofNullable(string).filter(JMPredicate.getIsEmpty().negate());
    }

    public static <T> Optional<T> getOptionalIfTrue(boolean bool, T target) {
        return bool ? Optional.ofNullable(target) : Optional.empty();
    }

    public static <T> Optional<T> getNullableAndFilteredOptional(T target, Predicate<T> predicate) {
        return Optional.ofNullable(target).filter(predicate);
    }

    public static <T, R> Optional<R> getOptionalIfExist(Optional<T> optional, Function<T, R> returnBuilderFunction) {
        return optional.map(returnBuilderFunction::apply);
    }

    public static <T1, T2, R> Optional<R> getOptionalIfExist(Optional<T1> firstOptional, Optional<T2> secondOptional, BiFunction<T1, T2, R> returnBuilderFunction) {
        return firstOptional.flatMap(t1 -> secondOptional.map(t2 -> returnBuilderFunction.apply(t1, t2)));
    }

    public static <T, C extends Collection<T>, R> Optional<R> getOptionalIfExist(C collection, Function<C, R> returnBuilderFunction) {
        return JMOptional.getOptional(collection).map(returnBuilderFunction);
    }

    public static <K, V, M extends Map<K, V>, R> Optional<R> getOptionalIfExist(M map, Function<M, R> returnBuilderFunction) {
        return JMOptional.getOptional(map).map(returnBuilderFunction);
    }

    public static <K, V, R> Optional<R> getValueAsOptIfExist(Map<K, V> map, K key, Function<V, R> returnBuilderFunction) {
        return JMOptional.getOptional(map, key).map(returnBuilderFunction::apply);
    }

    public static <T, C extends Collection<T>> Optional<C> getOptional(C collection) {
        return Optional.ofNullable(collection).filter(c -> c.size() > 0);
    }

    public static <T> Optional<T[]> getOptional(T[] array) {
        return Optional.ofNullable(array).filter(a -> ((Object[])a).length > 0);
    }

    public static <K, V, M extends Map<K, V>> Optional<M> getOptional(M map) {
        return Optional.ofNullable(map).filter(m -> m.size() > 0);
    }

    public static <K, V, M extends Map<K, V>> Optional<V> getOptional(M map, K key) {
        return Optional.ofNullable(map).map(m -> m.get(key));
    }

    public static <E, T extends Collection<E>> void ifExist(T collection, Consumer<T> consumer) {
        JMOptional.getOptional(collection).ifPresent(consumer);
    }

    public static <K, V, M extends Map<K, V>> void ifExist(M map, Consumer<M> consumer) {
        JMOptional.getOptional(map).ifPresent(consumer);
    }

    public static <T> void ifNotNull(T object, Consumer<T> consumer) {
        Optional.ofNullable(object).ifPresent(consumer);
    }

    public static <T> T orElseGetIfNull(T target, Supplier<T> elseGetSupplier) {
        return Optional.ofNullable(target).orElseGet(elseGetSupplier);
    }

    public static <T> T orElseIfNull(T target, T elseTarget) {
        return Optional.ofNullable(target).orElse(elseTarget);
    }

    public static <T, C extends Collection<T>> Stream<T> ifExistIntoStream(C collection) {
        return JMOptional.getOptional(collection).map(Collection::stream).orElseGet(Stream::empty);
    }

    public static boolean isPresentAll(Optional<?> ... optionals) {
        for (Optional<?> optional : optionals) {
            if (optional.isPresent()) continue;
            return false;
        }
        return true;
    }

    public static <T> List<T> getListIfIsPresent(Optional<T> ... optionals) {
        return Arrays.stream(optionals).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public static <T> List<T> getOrNullList(Optional<T> ... optionals) {
        return Arrays.stream(optionals).map(opt -> opt.orElse(null)).collect(Collectors.toList());
    }

    public static List<?> getObjectOrNullList(Optional<?> ... optionals) {
        return Arrays.stream(optionals).map(opt -> opt.orElse(null)).collect(Collectors.toList());
    }
}

