/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.datastructure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import kr.jm.utils.datastructure.JMArrays;
import kr.jm.utils.helper.JMOptional;
import kr.jm.utils.helper.JMStream;
import kr.jm.utils.helper.JMString;

public class JMCollections {
    public static <T, C extends Collection<T>> void ifNotNullOrEmptyConsume(C collection, Consumer<C> consumer) {
        JMOptional.getOptional(collection).ifPresent(consumer);
    }

    public static boolean isNotNullOrEmpty(Collection<?> collection) {
        return !JMCollections.isNullOrEmpty(collection);
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.size() == 0;
    }

    public static <T, L extends List<T>> T getLast(List<T> list) {
        return JMCollections.isNullOrEmpty(list) ? null : (T)list.get(list.size() - 1);
    }

    public static <T extends Comparable<T>> List<T> sort(List<T> list) {
        Collections.sort(list);
        return list;
    }

    public static <T> List<T> sort(List<T> list, Comparator<? super T> comparator) {
        list.sort(comparator);
        return list;
    }

    @SafeVarargs
    public static <E> List<E> buildList(E ... objects) {
        return Arrays.asList(objects);
    }

    public static <E> List<E> buildList(Iterable<E> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList());
    }

    public static <E> List<E> buildMergedList(Collection<E> collection1, Collection<E> collection2) {
        ArrayList<E> mergedList = new ArrayList<E>(collection1);
        mergedList.addAll(collection2);
        return mergedList;
    }

    public static List<String> buildListFromCsv(String csvString) {
        return JMCollections.buildList(JMArrays.buildArrayFromCsv(csvString));
    }

    public static List<String> buildListWithDelimiter(String stringWithDelimiter, String delimiter) {
        return JMStream.buildTokenStream(stringWithDelimiter, delimiter).collect(Collectors.toList());
    }

    public static List<String> buildListByLine(String stringByLine) {
        return JMCollections.buildListWithDelimiter(stringByLine, JMString.LINE_SEPARATOR);
    }

    public static <E> List<List<E>> splitIntoSubList(List<E> list, int targetSize) {
        int listSize = list.size();
        return JMStream.numberRange(0, listSize, targetSize).mapToObj(index -> list.subList(index, Math.min(index + targetSize, listSize))).collect(Collectors.toList());
    }

    public static <T> List<T> getReversed(Collection<T> collection) {
        ArrayList<T> reversedList = new ArrayList<T>(collection);
        Collections.reverse(reversedList);
        return reversedList;
    }

    public static <T, R> List<R> transformList(Collection<T> collection, Function<T, R> transformFunction) {
        return collection.stream().map(transformFunction).collect(Collectors.toList());
    }

    public static <T> List<T> newSynchronizedList() {
        return Collections.synchronizedList(new ArrayList());
    }

    public static <T> Set<T> newSet(Collection<T> collection) {
        return new HashSet<T>(collection);
    }

    public static <T> List<T> newList(Collection<T> collection) {
        return new ArrayList<T>(collection);
    }

    public static <K, V> Map<K, V> newMap(Collection<Map.Entry<K, V>> collection) {
        return collection.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @SafeVarargs
    public static <K, V> Map<K, V> newMap(Map.Entry<K, V> ... entries) {
        return JMCollections.newMap(Arrays.asList(entries));
    }
}

