/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.datastructure;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;
import kr.jm.utils.datastructure.JMCollections;
import kr.jm.utils.helper.JMOptional;

public class JMArrays {
    public static final String[] EMPTY_STRINGS = new String[0];

    @SafeVarargs
    public static <E> E[] buildArray(E ... objects) {
        return objects;
    }

    @SafeVarargs
    public static <V extends Comparable<V>> V[] sort(V ... array) {
        Arrays.sort(array);
        return array;
    }

    public static <V> V[] sort(V[] array, Comparator<? super V> comparator) {
        Arrays.sort(array, comparator);
        return array;
    }

    @SafeVarargs
    public static <V> V getLast(V ... array) {
        return JMArrays.isNullOrEmpty(array) ? null : (V)array[array.length - 1];
    }

    @SafeVarargs
    public static <V> boolean isNullOrEmpty(V ... array) {
        return array == null || array.length == 0;
    }

    @SafeVarargs
    public static <V> boolean isNotNullOrEmpty(V ... array) {
        return !JMArrays.isNullOrEmpty(array);
    }

    public static String[] buildArrayFromCsv(String csvString) {
        return csvString.split(",");
    }

    public static String[] buildArrayWithDelimiter(String stringWithDelimiter, String delimiter) {
        return JMArrays.toArray(JMCollections.buildListWithDelimiter(stringWithDelimiter, delimiter));
    }

    public static String[] toArray(Collection<String> stringCollection) {
        return JMOptional.getOptional(stringCollection).map(Collection::size).map(String[]::new).map(stringCollection::toArray).orElseGet(JMArrays::getEmptyStringArray);
    }

    public static String[] getEmptyStringArray() {
        return EMPTY_STRINGS;
    }

    public static String[] buildStringArray(Object ... objects) {
        return JMOptional.getOptional(objects).map(Arrays::stream).map(stream -> stream.map(Object::toString).collect(Collectors.toList()).toArray(new String[objects.length])).orElseGet(JMArrays::getEmptyStringArray);
    }

    public static Object[] buildObjectArray(Object ... objects) {
        return JMArrays.buildArray(objects);
    }
}

