/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import kr.jm.utils.helper.JMThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMThreadServiceForLimitedQueueSize {
    private static final Logger log = LoggerFactory.getLogger(JMThreadServiceForLimitedQueueSize.class);
    private int waitMillis;
    private int queueSize;
    private ExecutorService threadPool;
    private BlockingQueue<Runnable> threadQueue;

    public JMThreadServiceForLimitedQueueSize(int numOfThread, int waitMillis, int queueSize) {
        this(numOfThread, waitMillis, queueSize, JMThread.newThreadPool(numOfThread));
    }

    public JMThreadServiceForLimitedQueueSize(int numOfThread, int waitMillis, int queueSize, ExecutorService threadPool) {
        this.waitMillis = waitMillis;
        this.queueSize = queueSize;
        this.threadQueue = JMThread.getThreadQueue(threadPool);
        log.info("JMThreadService Start !!! - Number Of Worker = {}, Wait Millis = {}, Queue Size = {}", new Object[]{numOfThread, waitMillis, queueSize});
    }

    public int getCurrentQueueSize() {
        return this.threadQueue.size();
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public Future<?> submit(Runnable runnable) {
        this.checkThreadQueue();
        return this.threadPool.submit(runnable);
    }

    public <T> Future<T> submit(Callable<T> callable) {
        this.checkThreadQueue();
        return this.threadPool.submit(callable);
    }

    public void execute(Runnable runnable) {
        this.checkThreadQueue();
        this.threadPool.execute(runnable);
    }

    private void checkThreadQueue() {
        while (this.threadQueue.size() > this.queueSize) {
            log.warn("Hit The Maximum Queue Size Of Thread Pool !!! - Wait Millis = {}, Queue Size = {}", (Object)this.waitMillis, (Object)this.queueSize);
            JMThread.sleep(this.waitMillis);
        }
    }
}

