/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.stats.generator;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import kr.jm.utils.JMWordSplitter;
import kr.jm.utils.helper.JMFiles;
import kr.jm.utils.helper.JMLambda;

public class WordCountGenerator {
    public static Map<String, Long> buildCountMap(Pattern pattern, Path path) {
        return WordCountGenerator.buildCountMap(JMFiles.getLineStream(path).flatMap(pattern::splitAsStream));
    }

    public static Map<String, Long> buildCountMap(Pattern pattern, String text) {
        return WordCountGenerator.buildCountMap(pattern.splitAsStream(text));
    }

    public static Map<String, Long> buildCountMap(List<String> wordList) {
        return WordCountGenerator.buildCountMap(wordList.stream());
    }

    public static Map<String, Long> buildCountMap(Stream<String> wordStream) {
        return JMLambda.countBy(wordStream);
    }

    public Map<String, Long> buildCountMap(Path path) {
        return WordCountGenerator.buildCountMap(JMWordSplitter.DefaultSplitPattern, path);
    }

    public Map<String, Long> buildCountMap(String text) {
        return WordCountGenerator.buildCountMap(JMWordSplitter.DefaultSplitPattern, text);
    }
}

