/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.helper;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Stream;
import kr.jm.utils.enums.OS;
import kr.jm.utils.exception.JMExceptionManager;
import kr.jm.utils.helper.JMPath;
import kr.jm.utils.helper.JMPathOperation;
import kr.jm.utils.helper.JMString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMFiles {
    private static final Logger log = LoggerFactory.getLogger(JMFiles.class);

    public static Writer append(Writer writer, String string) {
        try {
            writer.append(string);
            return writer;
        }
        catch (IOException e) {
            return JMExceptionManager.handleExceptionAndReturn(log, e, "append", () -> writer, string);
        }
    }

    public static Writer appendLine(Writer writer, String line) {
        return JMFiles.append(writer, line + JMString.LINE_SEPARATOR);
    }

    public static Writer buildBufferedAppendWriter(Path path) {
        return JMFiles.buildBufferedAppendWriter(path, StandardCharsets.UTF_8);
    }

    public static Writer buildBufferedAppendWriter(Path path, Charset charset) {
        try {
            if (JMPath.notExists(path)) {
                JMPathOperation.createFileWithParentDirectories(path, new FileAttribute[0]);
            }
            BufferedWriter bufferedWriter = Files.newBufferedWriter(path, charset, StandardOpenOption.APPEND);
            OS.addShutdownHook(() -> {
                try {
                    bufferedWriter.close();
                }
                catch (IOException e) {
                    JMExceptionManager.logException(log, e, "buildBufferedAppendWriter.close", bufferedWriter, path, charset);
                }
            });
            return bufferedWriter;
        }
        catch (IOException e) {
            return (Writer)JMExceptionManager.handleExceptionAndReturnNull(log, e, "buildBufferedAppendWriter", path, charset);
        }
    }

    public static boolean writeString(String inputString, File targetFile) {
        if (!targetFile.exists()) {
            try {
                Files.write(targetFile.toPath(), inputString.getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                return JMExceptionManager.handleExceptionAndReturnFalse(log, e, "writeString", inputString, targetFile);
            }
        }
        return true;
    }

    public static String readString(File targetFile) {
        return JMFiles.readString(targetFile.toPath());
    }

    public static String readString(Path targetPath) {
        try {
            return new String(Files.readAllBytes(targetPath));
        }
        catch (IOException e) {
            return (String)JMExceptionManager.handleExceptionAndReturnNull(log, e, "readString", targetPath);
        }
    }

    public static String readString(File targetFile, String charsetName) {
        return JMFiles.readString(targetFile.toPath(), charsetName);
    }

    public static String readString(Path targetPath, String charsetName) {
        try {
            return new String(Files.readAllBytes(targetPath), Charset.forName(charsetName));
        }
        catch (IOException e) {
            return (String)JMExceptionManager.handleExceptionAndReturnNull(log, e, "readString", charsetName);
        }
    }

    public static String readString(String filePath) {
        return JMFiles.readString(JMFiles.getPath(filePath));
    }

    public static String readString(String filePath, String charsetName) {
        return JMFiles.readString(JMFiles.getPath(filePath), charsetName);
    }

    public static List<String> readLines(File targetFile) {
        return JMFiles.readLines(targetFile.toPath());
    }

    public static List<String> readLines(Path targetPath) {
        try {
            return Files.readAllLines(targetPath);
        }
        catch (IOException e) {
            return (List)JMExceptionManager.handleExceptionAndReturnNull(log, e, "readLines", targetPath);
        }
    }

    public static List<String> readLines(File targetFile, String charsetName) {
        return JMFiles.readLines(targetFile.toPath(), charsetName);
    }

    public static List<String> readLines(Path targetPath, String charsetName) {
        try {
            return Files.readAllLines(targetPath, Charset.forName(charsetName));
        }
        catch (IOException e) {
            return (List)JMExceptionManager.handleExceptionAndReturnNull(log, e, "readLines", targetPath, charsetName);
        }
    }

    public static List<String> readLines(String filePath) {
        return JMFiles.readLines(JMFiles.getPath(filePath));
    }

    public static List<String> readLines(String filePath, String charsetName) {
        return JMFiles.readLines(JMFiles.getPath(filePath), charsetName);
    }

    public static Path getPath(String filePath) {
        return FileSystems.getDefault().getPath(filePath, new String[0]);
    }

    public static String getExtension(File file) {
        return JMString.getExtension(file.getName());
    }

    public static String getPrefix(File file) {
        return JMString.getPrefixOfFileName(file.getName());
    }

    public static String[] getPrefixSuffix(File file) {
        return JMString.splitFileNameIntoPreSuffix(file.getName());
    }

    public static File createTempFile(File file) {
        String[] prefixSuffix = JMFiles.getPrefixSuffix(file);
        try {
            File tempFile = File.createTempFile(prefixSuffix[0], prefixSuffix[1]);
            tempFile.deleteOnExit();
            return tempFile;
        }
        catch (Exception e) {
            return (File)JMExceptionManager.handleExceptionAndReturnNull(log, e, "createTempFile", file);
        }
    }

    public static Stream<String> getLineStream(String filePath) {
        return JMFiles.getLineStream(JMFiles.getPath(filePath));
    }

    public static Stream<String> getLineStream(String filePath, Charset charset) {
        return JMFiles.getLineStream(JMFiles.getPath(filePath), charset);
    }

    public static Stream<String> getLineStream(Path path) {
        return JMFiles.getLineStream(path, null);
    }

    public static Stream<String> getLineStream(Path path, Charset charset) {
        try {
            return charset == null ? Files.lines(path) : Files.lines(path, charset);
        }
        catch (Exception e) {
            return JMExceptionManager.handleExceptionAndReturn(log, e, "getLineStream", Stream::empty, path, charset);
        }
    }
}

