/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.accumulator;

import java.util.function.Function;
import kr.jm.utils.accumulator.CountBytesSizeAccumulator;
import kr.jm.utils.collections.JMTimeSeries;
import kr.jm.utils.helper.JMOptional;

public class TimeSeriesCountBytesSizeAccumulator
extends JMTimeSeries<CountBytesSizeAccumulator> {
    public TimeSeriesCountBytesSizeAccumulator(int intervalSeconds) {
        super(intervalSeconds);
    }

    public double getCountPerSeconds(long timestamp) {
        return this.getNumber(timestamp, CountBytesSizeAccumulator::getCount) / (double)this.intervalSeconds;
    }

    public double getNumber(long timestamp, Function<CountBytesSizeAccumulator, Long> valueFunction) {
        return JMOptional.getOptional(this, timestamp).map(valueFunction).map(Long::doubleValue).orElse(0.0);
    }

    public double getBytesSizePerSeconds(long timestamp) {
        return this.getNumber(timestamp, CountBytesSizeAccumulator::getBytesSize) / (double)this.intervalSeconds;
    }
}

