/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.collections;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import kr.jm.utils.collections.JMTimeseries;
import kr.jm.utils.datastructure.JMMap;

public class JMListTimeseries<T>
extends JMTimeseries<List<T>> {
    private Supplier<List<T>> newListSupplier = ArrayList::new;

    public JMListTimeseries(long intervalSeconds) {
        super(intervalSeconds);
    }

    public void add(long timestamp, T object) {
        JMMap.getOrPutGetNew(this.timeseriesMap, this.buildKeyTimetamp(timestamp), this.newListSupplier).add(object);
    }

    public void addAll(long timestamp, List<T> objectList) {
        for (T object : objectList) {
            this.add(timestamp, object);
        }
    }

    @Override
    public String toString() {
        return "JMListTimeseries(intervalSeconds=" + this.getIntervalSeconds() + ", timeseriesMap=" + this.timeseriesMap.toString() + ")";
    }
}

