/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.time;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import kr.jm.utils.datastructure.JMMap;

public class JMTimeUtil {
    public static final String DefaultTimeZoneId = ZoneId.systemDefault().getId();
    public static final String UTC = "UTC";
    public static final String LONG_FORMAT_WITH_Z = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String LONG_FORMAT3_WITH_PLUS_TIMEZONE = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String LONG_FORMAT2_WITH_PLUS_TIMEZONE = "yyyy-MM-dd'T'HH:mm:ss.SSZ";
    public static final String LONG_FORMAT1_WITH_PLUS_TIMEZONE = "yyyy-MM-dd'T'HH:mm:ss.SZ";
    public static final String LONG_FORMAT_WITH_TIMEZONE = "yyyy-MM-dd'T'HH:mm:ss.SSSz";
    public static final String LONG_FORMAT3_WITHOUT_TIMEZONE = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String LONG_FORMAT2_WITHOUT_TIMEZONE = "yyyy-MM-dd'T'HH:mm:ss.SS";
    public static final String LONG_FORMAT1_WITHOUT_TIMEZONE = "yyyy-MM-dd'T'HH:mm:ss.S";
    public static final String SHORT_FORMAT_WITH_PLUS_TIMEZONE = "yyyyMMddHHmmss.SSSZ";
    public static final String SHORT_FORMAT_WITH_TIMEZONE = "yyyyMMddHHmmss.SSSz";
    public static final String SHORT_FORMAT_WITHOUT_TIMEZONE = "yyyyMMddHHmmss.SSS";
    public static final String DATETIME_FORMAT_WITH_PLUS_TIMEZONE = "yyyy-MM-dd'T'HH:mm:ssZ";
    public static final String DATETIME_FORMAT_WITH_Z = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String DATETIME_FORMAT_WITHOUT_TIMEZONE = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String UTC_0000 = "+0000";
    private static final Pattern isoTimestampZoneInfoPattern = Pattern.compile("[\\+|\\-][0-9]{4}$");
    private static Map<String, SimpleDateFormat> simpleDateFormatMap = new HashMap<String, SimpleDateFormat>();
    private static BiFunction<String, String, Supplier<SimpleDateFormat>> newSimpleDateFormatBuilder = (dateFormat, timeZoneId) -> () -> JMTimeUtil.setIfTimeZoneId(new SimpleDateFormat((String)dateFormat, Locale.US), timeZoneId);

    public static String changeIsoTimestampToIsoLocalDateTime(String isoTimestamp) {
        return JMTimeUtil.changeFormatAndTimeZone(isoTimestamp, DATETIME_FORMAT_WITHOUT_TIMEZONE, UTC);
    }

    public static String changeIsoTimestampToIsoInstant(String isoTimestamp) {
        return JMTimeUtil.changeFormatAndTimeZone(isoTimestamp, DATETIME_FORMAT_WITH_Z, UTC);
    }

    public static String getCurrentTimestampInUtc() {
        return JMTimeUtil.getTimeAsDefaultUtcFormat(System.currentTimeMillis());
    }

    public static String getCurrentTimestamp() {
        return JMTimeUtil.getTime(System.currentTimeMillis());
    }

    public static String getCurrentTimestamp(String timeFormat) {
        return JMTimeUtil.getTimeInUTC(System.currentTimeMillis(), timeFormat);
    }

    public static String getCurrentTimestamp(String timeFormat, String timeZoneId) {
        return JMTimeUtil.getTime(System.currentTimeMillis(), timeFormat, timeZoneId);
    }

    public static String getTime(long epochTimestamp) {
        return JMTimeUtil.getTimeAsLongFormatWithPlusTimezone(epochTimestamp);
    }

    public static String getTimeAsDefaultUtcFormat(long epochTimestamp) {
        return JMTimeUtil.getTimeInUTC(epochTimestamp, LONG_FORMAT_WITH_Z);
    }

    public static String getTimeAsLongFormatWithPlusTimezone(long epochTimestamp) {
        return JMTimeUtil.getTime(epochTimestamp, LONG_FORMAT3_WITH_PLUS_TIMEZONE);
    }

    public static String getTimeAsLongFormatWithTimezone(long epochTimestamp) {
        return JMTimeUtil.getTime(epochTimestamp, LONG_FORMAT_WITH_TIMEZONE);
    }

    public static String getTimeAsLongFormatWithoutTimezone(long epochTimestamp) {
        return JMTimeUtil.getTime(epochTimestamp, LONG_FORMAT3_WITHOUT_TIMEZONE);
    }

    public static String getTimeAsShortFormatWithPlusTimezone(long epochTimestamp) {
        return JMTimeUtil.getTime(epochTimestamp, SHORT_FORMAT_WITH_PLUS_TIMEZONE);
    }

    public static String getTimeAsShortFormatWithTimezone(long epochTimestamp) {
        return JMTimeUtil.getTime(epochTimestamp, SHORT_FORMAT_WITH_TIMEZONE);
    }

    public static String getTimeAsShortFormatWithoutTimezone(long epochTimestamp) {
        return JMTimeUtil.getTime(epochTimestamp, SHORT_FORMAT_WITHOUT_TIMEZONE);
    }

    public static String getTimeInUTC(long epochTimestamp, String timeFormat) {
        return JMTimeUtil.getTime(epochTimestamp, timeFormat, UTC);
    }

    public static String getTime(long epochTimestamp, String timeFormat) {
        return JMTimeUtil.getTime(epochTimestamp, timeFormat, ZoneId.systemDefault());
    }

    public static String getTime(long epochTimestamp, String timeFormat, String timeZoneId) {
        return JMTimeUtil.getTime(epochTimestamp, timeFormat, ZoneId.of(timeZoneId));
    }

    public static String getTime(long epochTimestamp, String timeFormat, ZoneId zoneId) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochTimestamp), zoneId).format(DateTimeFormatter.ofPattern(timeFormat));
    }

    public static String changeIsoTimestampInUTC(String isoTimestamp) {
        return JMTimeUtil.getTimeAsDefaultUtcFormat(JMTimeUtil.changeIsoTimestampToLong(isoTimestamp));
    }

    public static String changeFormatAndTimeZone(String isoTimestamp, String toBeTimeFormat, String timeZoneId) {
        return JMTimeUtil.getTime(JMTimeUtil.changeIsoTimestampToLong(isoTimestamp, timeZoneId), toBeTimeFormat, timeZoneId);
    }

    public static String changeFormatAndTimeZone(String isoTimestamp, String toBeTimeFormat) {
        return JMTimeUtil.changeFormatAndTimeZone(isoTimestamp, toBeTimeFormat, DefaultTimeZoneId);
    }

    public static long changeIsoTimestampToLong(String isoTimestamp) {
        return JMTimeUtil.changeIsoTimestampToLong(isoTimestamp, null);
    }

    public static long changeIsoTimestampToLong(String isoTimestamp, String timeZoneId) {
        isoTimestamp = JMTimeUtil.changeZTo0000(isoTimestamp);
        return JMTimeUtil.changeTimestampToLong(JMTimeUtil.getTimeFormat(isoTimestamp), isoTimestamp, timeZoneId);
    }

    private static String changeZTo0000(String isoTimestamp) {
        int index = isoTimestamp.length() - 1;
        char lastChar = isoTimestamp.charAt(index);
        return lastChar == 'Z' || lastChar == 'z' ? isoTimestamp.substring(0, index) + UTC_0000 : isoTimestamp;
    }

    private static String getTimeFormat(String isoTimestamp) {
        boolean isContainsDot = isoTimestamp.contains(".");
        boolean isContainsPlusOrMinus = isoTimestampZoneInfoPattern.matcher(isoTimestamp).find();
        int length = isoTimestamp.length();
        if (isContainsDot && isContainsPlusOrMinus) {
            if (length == 28) {
                return LONG_FORMAT3_WITH_PLUS_TIMEZONE;
            }
            if (length == 27) {
                return LONG_FORMAT2_WITH_PLUS_TIMEZONE;
            }
            if (length == 26) {
                return LONG_FORMAT1_WITH_PLUS_TIMEZONE;
            }
        } else if (isContainsDot && !isContainsPlusOrMinus) {
            if (length == 23) {
                return LONG_FORMAT3_WITHOUT_TIMEZONE;
            }
            if (length == 22) {
                return LONG_FORMAT2_WITHOUT_TIMEZONE;
            }
            if (length == 21) {
                return LONG_FORMAT1_WITHOUT_TIMEZONE;
            }
        } else {
            if (!isContainsDot && !isContainsPlusOrMinus && length == 19) {
                return DATETIME_FORMAT_WITHOUT_TIMEZONE;
            }
            if (!isContainsDot && isContainsPlusOrMinus && length == 24) {
                return DATETIME_FORMAT_WITH_PLUS_TIMEZONE;
            }
        }
        throw new RuntimeException("Don't Support Format ISO Timestamp!!! - " + isoTimestamp);
    }

    private static SimpleDateFormat getSimpleDateFormat(String dateFormat) {
        return JMTimeUtil.getSimpleDateFormat(dateFormat, null);
    }

    private static SimpleDateFormat getSimpleDateFormat(String dateFormat, String timeZoneId) {
        return (SimpleDateFormat)((Object)JMMap.getOrPutGetNew(simpleDateFormatMap, JMTimeUtil.buildSimpleDateFormatKey(dateFormat, timeZoneId), newSimpleDateFormatBuilder.apply(dateFormat, timeZoneId)));
    }

    private static String buildSimpleDateFormatKey(String dateFormat, String timeZoneId) {
        return dateFormat + timeZoneId;
    }

    public static long changeTimestampToLong(String dateFormat, String timestamp, String timeZoneId) {
        return JMTimeUtil.changeTimestampToLong(JMTimeUtil.getSimpleDateFormat(dateFormat, timeZoneId), timestamp);
    }

    public static long changeTimestampToLong(String dateFormat, String timestamp) {
        return JMTimeUtil.changeTimestampToLong(JMTimeUtil.getSimpleDateFormat(dateFormat), timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long changeTimestampToLong(SimpleDateFormat simpleDateFormat, String timestamp) {
        try {
            SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
            synchronized (simpleDateFormat2) {
                return simpleDateFormat.parse(timestamp).getTime();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String changeTimestampToNewFormat(String dateFormat, String timestamp, String newDateFormat) {
        return JMTimeUtil.getTime(JMTimeUtil.changeTimestampToLong(JMTimeUtil.getSimpleDateFormat(dateFormat), timestamp), newDateFormat);
    }

    public static String changeTimestampToIsoInstant(String dateFormat, String timestamp) {
        return JMTimeUtil.getTime(JMTimeUtil.changeTimestampToLong(JMTimeUtil.getSimpleDateFormat(dateFormat), timestamp), DATETIME_FORMAT_WITH_Z, UTC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SimpleDateFormat setIfTimeZoneId(SimpleDateFormat simpleDateFormat, String timeZoneId) {
        SimpleDateFormat simpleDateFormat2 = simpleDateFormat;
        synchronized (simpleDateFormat2) {
            if (timeZoneId != null) {
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone(timeZoneId));
            }
            return simpleDateFormat;
        }
    }

    public static long getTimeMillis(int year, int month, int dayOfMonth, int hour, int minute, int second, int mills, String timeZoneId) {
        return ZonedDateTime.of(year, month, dayOfMonth, hour, minute, second, new Long(TimeUnit.MILLISECONDS.toNanos(mills)).intValue(), ZoneId.of(timeZoneId)).toInstant().toEpochMilli();
    }

    public static long getTimeMillisWithNano(int year, int month, int dayOfMonth, int hour, int minute, int second, int nanoOfSecond, String timeZoneId) {
        return ZonedDateTime.of(year, month, dayOfMonth, hour, minute, second, nanoOfSecond, ZoneId.of(timeZoneId)).toInstant().toEpochMilli();
    }

    public static long getTimeMillis(int year, int month, int dayOfMonth, int hour, int minute, int second, String timeZoneId) {
        return ZonedDateTime.of(year, month, dayOfMonth, hour, minute, second, 0, ZoneId.of(timeZoneId)).toInstant().toEpochMilli();
    }

    public static long getTimeMillis(int year, int month, int dayOfMonth, int hour, int minute, String timeZoneId) {
        return JMTimeUtil.getTimeMillis(year, month, dayOfMonth, hour, minute, 0, timeZoneId);
    }

    public static long getTimeMillis(int year, int month, int dayOfMonth, int hour, String timeZoneId) {
        return JMTimeUtil.getTimeMillis(year, month, dayOfMonth, hour, 0, 0, timeZoneId);
    }

    public static long getTimeMillis(int year, int month, int dayOfMonth, String timeZoneId) {
        return JMTimeUtil.getTimeMillis(year, month, dayOfMonth, 0, 0, 0, timeZoneId);
    }

    public static long getTimeMillis(int year, int month, String timeZoneId) {
        return JMTimeUtil.getTimeMillis(year, month, 0, 0, 0, 0, timeZoneId);
    }

    public static long getTimeMillis(int year, String timeZoneId) {
        return JMTimeUtil.getTimeMillis(year, 0, 0, 0, 0, 0, timeZoneId);
    }
}

