/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.helper;

import java.util.Collection;
import kr.jm.utils.AutoStringBuilder;
import org.slf4j.Logger;

public class JMLog {
    public static void infoBeforeStart(Logger log, String methodName) {
        log.info(JMLog.buildMethodLogString(methodName));
    }

    public static void infoBeforeStart(Logger log, String methodName, Object ... params) {
        log.info(JMLog.buildMethodLogString(methodName, params));
    }

    public static void infoAndDebugBeforeStart(Logger log, String methodName, Object ... params) {
        int length = params.length;
        Object[] newParams = new Object[length];
        boolean hasCollection = false;
        for (int i = 0; i < length; ++i) {
            if (params[i] instanceof Collection) {
                newParams[i] = ((Collection)params[i]).size();
                hasCollection = true;
                continue;
            }
            newParams[i] = params[i];
        }
        if (hasCollection) {
            log.info(JMLog.buildMethodLogString(methodName, newParams));
        }
        log.debug(JMLog.buildMethodLogString(methodName, params));
    }

    public static void errorForException(Logger log, Throwable throwable, String methodName) {
        log.error(JMLog.buildMethodLogString(methodName), throwable);
    }

    public static void errorForException(Logger log, Throwable throwable, String methodName, Object ... params) {
        log.error(JMLog.buildMethodLogString(methodName, params), throwable);
    }

    private static String buildMethodLogString(String methodName) {
        return methodName + "()";
    }

    private static String buildMethodLogString(String methodName, Object[] params) {
        AutoStringBuilder logASB = new AutoStringBuilder(", ");
        logASB.getStringBuilder().append(methodName).append("(");
        for (Object param : params) {
            if (param == null) {
                logASB.append("null");
                continue;
            }
            logASB.append(param.toString());
        }
        String finalLogString = logASB.removeLastAutoAppendingString().getStringBuilder().append(")").toString();
        return finalLogString;
    }

    public static void debugBeforeStart(Logger log, String methodName, Object ... params) {
        log.debug(JMLog.buildMethodLogString(methodName, params));
    }

    public static void debugBeforeStart(Logger log, String methodName) {
        log.debug(JMLog.buildMethodLogString(methodName));
    }

    public static void warnBeforeStart(Logger log, String methodName, Object ... params) {
        log.warn(JMLog.buildMethodLogString(methodName, params));
    }

    public static void warnBeforeStart(Logger log, String methodName) {
        log.warn(JMLog.buildMethodLogString(methodName));
    }
}

