/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.datastructure;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kr.jm.utils.helper.JMOptional;

public class JMMap {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> List<V> removeAllIfByKey(Map<K, V> map, Predicate<? super K> predicate) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return map.keySet().stream().filter(predicate).collect(Collectors.toList()).stream().map(map::remove).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> List<V> removeAllIfByEntry(Map<K, V> map, Predicate<? super Map.Entry<K, V>> predicate) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return map.entrySet().stream().filter(predicate).map(Map.Entry::getKey).collect(Collectors.toList()).stream().map(map::remove).collect(Collectors.toList());
        }
    }

    public static <K, V> V getOrElse(Map<K, V> map, K key, Supplier<V> valueSupplier) {
        return JMOptional.getOptional(map, key).orElseGet(valueSupplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> V getOrPutGetNew(Map<K, V> map, K key, Supplier<V> newValueSupplier) {
        Map map2 = map;
        synchronized (map2) {
            return (V)JMOptional.getOptional(map, key).orElseGet(() -> JMMap.putGetNew(map, key, newValueSupplier.get()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> V getOrPutGetNew(Map<K, V> map, K key, V newValue) {
        Map map2 = map;
        synchronized (map2) {
            return (V)JMOptional.getOptional(map, key).orElseGet(() -> JMMap.putGetNew(map, key, newValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V, K> V putGetNew(Map<K, V> map, K key, V newValue) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            map.put(key, newValue);
            return newValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V, NK> Map<NK, V> newChangedKeyMap(Map<K, V> map, Function<K, NK> changingKeyFunction) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return map.entrySet().stream().collect(Collectors.toMap(entry -> changingKeyFunction.apply(entry.getKey()), Map.Entry::getValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V, NK> Map<NK, V> newFilteredChangedKeyMap(Map<K, V> map, Predicate<? super Map.Entry<K, V>> filter, Function<K, NK> changingKeyFunction) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return map.entrySet().stream().filter(filter).collect(Collectors.toMap(entry -> changingKeyFunction.apply(entry.getKey()), Map.Entry::getValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V, NV> Map<K, NV> newChangedValueMap(Map<K, V> map, Function<V, NV> changingValueFunction) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> changingValueFunction.apply(entry.getValue())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V, NV> Map<K, NV> newFilteredChangedValueMap(Map<K, V> map, Predicate<Map.Entry<K, V>> filter, Function<V, NV> changingValueFunction) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return map.entrySet().stream().filter(filter).collect(Collectors.toMap(Map.Entry::getKey, entry -> changingValueFunction.apply(entry.getValue())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V, NK, NV> Map<NK, NV> newChangedKeyValueMap(Map<K, V> map, Function<K, NK> changingKeyFunction, Function<V, NV> changingValueFunction) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return map.entrySet().stream().collect(Collectors.toMap(entry -> changingKeyFunction.apply(entry.getKey()), entry -> changingValueFunction.apply(entry.getValue())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V, NK, NV> Map<NK, NV> newFilteredChangedKeyValueMap(Map<K, V> map, Predicate<? super Map.Entry<K, V>> filter, Function<K, NK> changingKeyFunction, Function<V, NV> changingValueFunction) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return map.entrySet().stream().filter(filter).collect(Collectors.toMap(entry -> changingKeyFunction.apply(entry.getKey()), entry -> changingValueFunction.apply(entry.getValue())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> Map<K, V> newFilteredMap(Map<K, V> map, Predicate<? super Map.Entry<K, V>> filter) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return map.entrySet().stream().filter(filter).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> Map<K, V> sort(Map<K, V> map, Comparator<K> comparator) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            TreeMap<K, V> sortedMap = new TreeMap<K, V>(comparator);
            sortedMap.putAll(map);
            return sortedMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K extends Comparable<K>, V> Map<K, V> sort(Map<K, V> map) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return new TreeMap<K, V>(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> Stream<Map.Entry<K, V>> sortedStream(Map<K, V> map, Comparator<? super Map.Entry<K, V>> comparator) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return map.entrySet().stream().sorted(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K extends Comparable<K>, V> Stream<Map.Entry<K, V>> sortedStream(Map<K, V> map) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return map.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey));
        }
    }

    public static <K, V extends Comparable<V>> Map<K, V> sortByValue(Map<K, V> map) {
        return JMMap.sort(map, (k1, k2) -> ((Comparable)map.get(k1)).compareTo(map.get(k2)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V extends Comparable<V>> Stream<Map.Entry<K, V>> sortedStreamByValue(Map<K, V> map) {
        Map<K, V> map2 = map;
        synchronized (map2) {
            return map.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getValue));
        }
    }

    public static boolean isNotNullOrEmpty(Map<?, ?> map) {
        return !JMMap.isNullOrEmpty(map);
    }

    public static boolean isNullOrEmpty(Map<?, ?> map) {
        return map == null || map.size() == 0;
    }
}

