/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import kr.jm.utils.helper.JMLambda;
import kr.jm.utils.helper.JMOptional;
import kr.jm.utils.helper.JMPredicate;

public class JMLimitedList<E>
implements Collection<E> {
    private int currentIndex = -1;
    private int capacity;
    private LinkedList<E> linkedList;

    public JMLimitedList(int capacity) {
        this.capacity = capacity;
        this.linkedList = new LinkedList();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public Optional<E> getFirst() {
        return JMOptional.getOptional(this.linkedList).map(LinkedList::getFirst);
    }

    public Optional<E> getLast() {
        return JMOptional.getOptional(this.linkedList).map(LinkedList::getLast);
    }

    public Optional<E> get(int index) {
        return JMOptional.getOptional(this.linkedList).filter(JMPredicate.getGreaterSize(0).and(JMPredicate.getGreaterSize(index))).map(l -> l.get(index));
    }

    public Optional<E> getCurrent() {
        return this.get(this.currentIndex);
    }

    public List<E> subList(int fromIndex, int toIndex) {
        return this.linkedList.subList(fromIndex, toIndex);
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public Optional<E> getPrevious() {
        return Optional.of(this.currentIndex).filter(JMPredicate.getGreater(0)).map(i -> this.linkedList.get(--this.currentIndex));
    }

    public Optional<E> getNext() {
        return Optional.of(this.currentIndex).filter(JMPredicate.getLess(this.linkedList.size() - 1)).map(i -> this.linkedList.get(++this.currentIndex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E e) {
        LinkedList<E> linkedList = this.linkedList;
        synchronized (linkedList) {
            return this.capacity > this.linkedList.size() ? this.addAndChangeCurrentIndex(e) : Optional.of(this.linkedList.remove()).map(JMLambda.changeInto(this.addAndChangeCurrentIndex(e))).get().booleanValue();
        }
    }

    private boolean addAndChangeCurrentIndex(E e) {
        this.linkedList.add(e);
        this.initCurrentIndex();
        return true;
    }

    private void initCurrentIndex() {
        this.currentIndex = this.linkedList.size() - 1;
    }

    @Override
    public int size() {
        return this.linkedList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.linkedList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.linkedList.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.linkedList.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.linkedList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.linkedList.toArray(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        LinkedList<E> linkedList = this.linkedList;
        synchronized (linkedList) {
            this.initCurrentIndex();
            return this.linkedList.remove(o);
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.linkedList.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return c.stream().allMatch(this::add);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        LinkedList<E> linkedList = this.linkedList;
        synchronized (linkedList) {
            this.initCurrentIndex();
            return this.linkedList.removeAll(c);
        }
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.linkedList.retainAll(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        LinkedList<E> linkedList = this.linkedList;
        synchronized (linkedList) {
            this.initCurrentIndex();
            this.linkedList.clear();
        }
    }

    @Override
    public boolean equals(Object o) {
        return this.linkedList.equals(o);
    }

    @Override
    public int hashCode() {
        return this.linkedList.hashCode();
    }

    public String toString() {
        return this.linkedList.toString();
    }
}

