/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.exception;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import kr.jm.utils.AutoStringBuilder;
import kr.jm.utils.exception.ErrorMessageHistory;
import kr.jm.utils.helper.JMLog;
import kr.jm.utils.helper.JMResources;
import org.slf4j.Logger;

public class JMExceptionManager {
    private static final String ERROR_HISTORY_SIZE = "error.history.size";
    private static final String LINE_SEPARATOR;
    private static final int maxQueueSize;
    private static List<ErrorMessageHistory> errorMessageHistoryList;
    private static long errorCount;

    public static void logException(Logger log, Throwable throwable, String methodName, Object ... params) {
        if (params.length > 0) {
            JMLog.errorForException(log, throwable, methodName, params);
        } else {
            JMLog.errorForException(log, throwable, methodName);
        }
        JMExceptionManager.increaseErrorCount();
        JMExceptionManager.recordErrorMessageHistory(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recordErrorMessageHistory(Throwable throwable) {
        List<ErrorMessageHistory> list = errorMessageHistoryList;
        synchronized (list) {
            errorMessageHistoryList.add(new ErrorMessageHistory(System.currentTimeMillis(), JMExceptionManager.getStackTraceString(throwable)));
            if (errorMessageHistoryList.size() > maxQueueSize) {
                errorMessageHistoryList.remove(0);
            }
        }
    }

    private static String getStackTraceString(Throwable throwable) {
        AutoStringBuilder stackTraceStringBuilder = new AutoStringBuilder(LINE_SEPARATOR);
        stackTraceStringBuilder.append(throwable.toString());
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            stackTraceStringBuilder.append(stackTraceElement.toString());
        }
        return stackTraceStringBuilder.autoToString();
    }

    public static List<ErrorMessageHistory> getErrorMessageHistoryList() {
        return errorMessageHistoryList;
    }

    public static void clearAll() {
        JMExceptionManager.removeErrorMessgeHistoryList();
        JMExceptionManager.resetErrorCount();
    }

    public static synchronized void removeErrorMessgeHistoryList() {
        errorMessageHistoryList.clear();
    }

    public static long getErrorCount() {
        return errorCount;
    }

    public static void resetErrorCount() {
        errorCount = 0L;
    }

    public static void increaseErrorCount() {
        ++errorCount;
    }

    public static <T> T handleExceptionAndReturnNull(Logger log, Throwable throwable, String method, Object ... params) {
        JMExceptionManager.logException(log, throwable, method, params);
        return null;
    }

    public static boolean handleExceptionAndReturnFalse(Logger log, Throwable throwable, String method, Object ... params) {
        JMExceptionManager.logException(log, throwable, method, params);
        return false;
    }

    public static <T> T handleExceptionAndReturn(Logger log, Throwable throwable, String method, Supplier<T> returnSupplier, Object ... params) {
        JMExceptionManager.logException(log, throwable, method, params);
        return returnSupplier.get();
    }

    public static <T> T handleExceptionAndThrowRuntimeEx(Logger log, Throwable throwable, String method, Object ... params) {
        JMExceptionManager.logException(log, throwable, method, params);
        throw new RuntimeException(throwable);
    }

    public static RuntimeException handleExceptionAndReturnRuntimeEx(Logger log, Throwable throwable, String method, Object ... params) {
        JMExceptionManager.logException(log, throwable, method, params);
        return new RuntimeException(throwable);
    }

    public static <T> Optional<T> handleExceptionAndReturnEmptyOptional(Logger log, Throwable throwable, String method, Object ... params) {
        return Optional.empty();
    }

    public static RuntimeException getDontSupportMethodRuntimeException() {
        return new RuntimeException("Don't Support Method !!!");
    }

    static {
        JMResources.setSystemPropertyIfIsNull(ERROR_HISTORY_SIZE, 500);
        LINE_SEPARATOR = System.getProperty("line.separator");
        maxQueueSize = new Integer(JMResources.getSystemProperty(ERROR_HISTORY_SIZE));
        errorMessageHistoryList = new LinkedList<ErrorMessageHistory>();
        errorCount = 0L;
    }
}

