/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.utils;

import com.google.common.base.Strings;
import java.util.Iterator;
import java.util.Locale;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class LangUtils {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    private LangUtils() {
    }

    public static boolean isBlank(String s) {
        return s == null || s.isEmpty() || s.trim().isEmpty();
    }

    public static boolean containsIgnoreCase(String s, String ss) {
        if (s == null || ss == null) {
            return false;
        }
        return s.toLowerCase(Locale.ROOT).contains(ss.toLowerCase(Locale.ROOT));
    }

    public static String capitalize(String s) {
        if (Strings.isNullOrEmpty((String)s)) {
            return s;
        }
        int ch = s.codePointAt(0);
        if ((Character.getType(ch) & 2) == 0) {
            return s;
        }
        if (Character.isBmpCodePoint(ch = Character.toUpperCase(ch))) {
            return (char)ch + s.substring(1);
        }
        return Character.highSurrogate(ch) + Character.lowSurrogate(ch) + s.substring(2);
    }

    public static String uncapitalize(String s) {
        if (Strings.isNullOrEmpty((String)s)) {
            return s;
        }
        int ch = s.codePointAt(0);
        if ((Character.getType(ch) & 1) == 0) {
            return s;
        }
        if (Character.isBmpCodePoint(ch = Character.toLowerCase(ch))) {
            return (char)ch + s.substring(1);
        }
        return Character.highSurrogate(ch) + Character.lowSurrogate(ch) + s.substring(2);
    }

    public static String join(CharSequence delimiter, Stream<?> stream) {
        return stream.map(item -> item.toString()).collect(Collectors.joining(delimiter));
    }

    public static String join(CharSequence delimiter, Iterator<?> iterator) {
        Spliterator<?> spliterator = Spliterators.spliteratorUnknownSize(iterator, 0);
        Stream<?> stream = StreamSupport.stream(spliterator, false);
        return LangUtils.join(delimiter, stream);
    }

    public static String join(CharSequence delimiter, Iterable<?> iterable) {
        return LangUtils.join(delimiter, iterable.iterator());
    }
}

