/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.TestCase;
import jp.vmi.selenium.selenese.command.AbstractCommand;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.command.StartMarker;
import jp.vmi.selenium.selenese.result.CommandResult;
import jp.vmi.selenium.selenese.result.Error;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;

public class Run
extends AbstractCommand {
    private static final int ARG_TEST_CASE_NAME = 0;

    Run(int index, String name, String ... args) {
        super(index, name, args, ArgumentType.VALUE);
    }

    @Override
    protected Result executeImpl(Context context, String ... curArgs) {
        String testCaseName = curArgs[0];
        TestCase testCase = (TestCase)context.getTestCaseMap().get(testCaseName);
        if (testCase == null) {
            return new Error("Missing test-case: " + testCaseName);
        }
        TestCase current = context.getCurrentTestCase();
        String seq = context.getCommandListIterator().getCommandSequence().toString();
        StartMarker marker = new StartMarker(this, "Start: " + testCaseName);
        long now = System.currentTimeMillis();
        CommandResult markerResult = new CommandResult(seq, marker, marker.getScreenshots(), marker.getResult(), now, now);
        current.getResultList().add(markerResult);
        Result result = testCase.execute(current, context);
        return result == Success.SUCCESS ? new Success("Success: " + testCaseName) : result;
    }
}

