/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import java.util.Set;
import jp.vmi.selenium.runner.model.side.SideCommand;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.command.AbstractCommand;
import jp.vmi.selenium.selenese.command.ArgumentType;
import jp.vmi.selenium.selenese.command.ClickHandler;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import jp.vmi.selenium.selenese.utils.Wait;
import org.openqa.selenium.ElementNotInteractableException;
import org.openqa.selenium.WebDriver;

public class Click
extends AbstractCommand {
    private static final int ARG_LOCATOR = 0;
    private static final long RETRY_INTERVAL = 100L;

    Click(int index, String name, String ... args) {
        super(index, name, args, ArgumentType.LOCATOR);
    }

    @Override
    protected Result executeImpl(Context context, String ... curArgs) {
        String locator = curArgs[0];
        return ClickHandler.handleClick(context, locator, element -> {
            Success result;
            Set prevWinHandles;
            WebDriver driver;
            SideCommand sideCommand = this.getSideCommand();
            if (sideCommand != null && sideCommand.isOpensWindow()) {
                driver = context.getWrappedDriver();
                prevWinHandles = driver.getWindowHandles();
            } else {
                driver = null;
                prevWinHandles = null;
            }
            try {
                element.click();
                result = Success.SUCCESS;
            }
            catch (ElementNotInteractableException e) {
                context.executeScript("arguments[0].click()", element);
                result = new Success("Success (the element is not visible)");
            }
            if (prevWinHandles != null) {
                long windowTimeout = sideCommand.getWindowTimeout() * 1000L * 1000L;
                long start = System.nanoTime();
                block2: do {
                    Set curWinHandles = driver.getWindowHandles();
                    for (String h : curWinHandles) {
                        if (prevWinHandles.contains(h)) continue;
                        context.getVarsMap().put(sideCommand.getWindowHandleName(), h);
                        break block2;
                    }
                    Wait.sleep(100L);
                } while (System.nanoTime() - start <= windowTimeout);
            }
            return result;
        });
    }
}

