/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.webdriver;

import jp.vmi.selenium.webdriver.DriverOptions;
import jp.vmi.selenium.webdriver.WebDriverFactory;
import org.apache.commons.exec.OS;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerDriverService;
import org.openqa.selenium.ie.InternetExplorerOptions;

public class IEDriverFactory
extends WebDriverFactory {
    public static final String BROWSER_NAME = "ie";

    @Override
    public String getBrowserName() {
        return BROWSER_NAME;
    }

    public static InternetExplorerOptions newInternetExplorerOptions(DriverOptions driverOptions) {
        InternetExplorerOptions options = new InternetExplorerOptions();
        Proxy proxy = IEDriverFactory.newProxy(driverOptions);
        if (proxy != null) {
            options.setProxy(proxy);
        }
        return options;
    }

    @Override
    public WebDriver newInstance(DriverOptions driverOptions) {
        if (!OS.isFamilyWindows()) {
            throw new UnsupportedOperationException("Unsupported platform: " + Platform.getCurrent());
        }
        InternetExplorerDriverService service = (InternetExplorerDriverService)IEDriverFactory.setupBuilder(new InternetExplorerDriverService.Builder(), driverOptions, DriverOptions.DriverOption.IEDRIVER).build();
        InternetExplorerOptions options = IEDriverFactory.newInternetExplorerOptions(driverOptions);
        options.merge((Capabilities)driverOptions.getCapabilities());
        InternetExplorerDriver driver = new InternetExplorerDriver(service, options);
        this.setInitialWindowSize((WebDriver)driver, driverOptions);
        return driver;
    }
}

