/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.webdriver;

import java.io.File;
import java.io.IOException;
import jp.vmi.selenium.webdriver.DriverOptions;
import jp.vmi.selenium.webdriver.WebDriverFactory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.GeckoDriverService;
import org.openqa.selenium.firefox.ProfilesIni;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirefoxDriverFactory
extends WebDriverFactory {
    public static final String BROWSER_NAME = "firefox";
    private static final Logger log = LoggerFactory.getLogger(FirefoxDriverFactory.class);

    @Override
    public String getBrowserName() {
        return BROWSER_NAME;
    }

    public static FirefoxOptions newFirefoxOptions(DriverOptions driverOptions) {
        Proxy proxy;
        FirefoxOptions options = new FirefoxOptions();
        if (driverOptions.has(DriverOptions.DriverOption.HEADLESS)) {
            options.setHeadless(driverOptions.getBoolean(DriverOptions.DriverOption.HEADLESS));
        }
        if ((proxy = FirefoxDriverFactory.newProxy(driverOptions)) != null) {
            options.setProxy(proxy);
        }
        return options;
    }

    @Override
    public WebDriver newInstance(DriverOptions driverOptions) {
        FirefoxProfile profile;
        GeckoDriverService service = (GeckoDriverService)FirefoxDriverFactory.setupBuilder(new GeckoDriverService.Builder(), driverOptions, DriverOptions.DriverOption.GECKODRIVER).build();
        FirefoxOptions firefoxOptions = FirefoxDriverFactory.newFirefoxOptions(driverOptions);
        String firefoxBin = FirefoxDriverFactory.getFirefoxBinary(driverOptions);
        if (firefoxBin != null) {
            firefoxOptions.setBinary(firefoxBin);
        }
        if (driverOptions.has(DriverOptions.DriverOption.CLI_ARGS)) {
            firefoxOptions.addArguments(driverOptions.getCliArgs());
        }
        if ((profile = FirefoxDriverFactory.getFirefoxProfile(driverOptions)) != null) {
            firefoxOptions.setProfile(profile);
        }
        firefoxOptions.merge((Capabilities)driverOptions.getCapabilities());
        FirefoxDriver driver = new FirefoxDriver(service, firefoxOptions);
        this.setInitialWindowSize((WebDriver)driver, driverOptions);
        return driver;
    }

    public static void setDriverSpecificCapabilitiesForRemoteWebDriver(DesiredCapabilities caps, DriverOptions driverOptions) {
        String firefoxBin = FirefoxDriverFactory.getFirefoxBinary(driverOptions);
        if (firefoxBin != null) {
            caps.setCapability("firefox_binary", firefoxBin);
            log.info("Firefox binary: {}", (Object)firefoxBin);
        }
        if (driverOptions.has(DriverOptions.DriverOption.CLI_ARGS)) {
            log.warn("Ignore --cli-args with RemoteWebDriver.");
        }
        FirefoxProfile profile = FirefoxDriverFactory.getFirefoxProfile(driverOptions);
        if (driverOptions.has(DriverOptions.DriverOption.PROXY)) {
            if (profile == null) {
                profile = new FirefoxProfile();
            }
            FirefoxDriverFactory.setProxyConfiguration(profile, driverOptions);
        }
        if (profile != null) {
            String json;
            try {
                json = profile.toJson();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            caps.setCapability("firefox_profile", json);
            log.info("Convert Firefox profile to JSON: {} bytes", (Object)json.length());
        }
    }

    private static String getFirefoxBinary(DriverOptions driverOptions) {
        if (driverOptions.has(DriverOptions.DriverOption.FIREFOX)) {
            return driverOptions.get(DriverOptions.DriverOption.FIREFOX);
        }
        return System.getProperty("webdriver.firefox.bin");
    }

    private static FirefoxProfile getFirefoxProfile(DriverOptions driverOptions) {
        FirefoxProfile profile;
        if (!driverOptions.has(DriverOptions.DriverOption.PROFILE) && !driverOptions.has(DriverOptions.DriverOption.PROFILE_DIR)) {
            return null;
        }
        String profileName = driverOptions.get(DriverOptions.DriverOption.PROFILE);
        String profileDir = driverOptions.get(DriverOptions.DriverOption.PROFILE_DIR);
        if (profileName != null) {
            if (profileDir != null) {
                throw new IllegalArgumentException("Can't specify both '--profile' and '--profile-dir' at once");
            }
            ProfilesIni allProfiles = new ProfilesIni();
            profile = allProfiles.getProfile(profileName);
            if (profile == null) {
                throw new IllegalArgumentException("Profile '" + profile + "' does not exist.");
            }
            log.info("Firefox profile: {}", (Object)profileName);
        } else {
            File dir = new File(profileDir);
            if (!dir.isDirectory()) {
                throw new IllegalArgumentException("Missing profile directory: " + profileDir);
            }
            profile = new FirefoxProfile(dir);
            log.info("Firefox profile directory: {}", (Object)profileDir);
        }
        return profile;
    }

    private static void setProxyConfiguration(FirefoxProfile profile, DriverOptions driverOptions) {
        String proxy = driverOptions.get(DriverOptions.DriverOption.PROXY);
        String[] ps = proxy.split(":", 2);
        String host = ps[0];
        int port = ps.length == 2 ? Integer.parseInt(ps[1]) : 80;
        String noProxy = driverOptions.has(DriverOptions.DriverOption.NO_PROXY) ? driverOptions.get(DriverOptions.DriverOption.NO_PROXY) : " ";
        profile.setPreference("network.proxy.type", 1);
        profile.setPreference("network.proxy.http", host);
        profile.setPreference("network.proxy.http_port", port);
        profile.setPreference("network.proxy.ssl", host);
        profile.setPreference("network.proxy.ssl_port", port);
        profile.setPreference("network.proxy.ftp", host);
        profile.setPreference("network.proxy.ftp_port", port);
        profile.setPreference("network.proxy.socks", host);
        profile.setPreference("network.proxy.socks_port", port);
        profile.setPreference("network.proxy.no_proxies_on", noProxy);
    }
}

