/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.utils;

import java.util.Set;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.utils.KeyValue;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;

public class WindowSelector {
    private static final String NO_PREFIX = "";
    private static final long WAIT_AFTER_SELECTING_WINDOW = 500L;
    private static WindowSelector windowSelector = new WindowSelector();

    public static void setInstance(WindowSelector ws) {
        windowSelector = ws;
    }

    public static WindowSelector getInstance() {
        return windowSelector;
    }

    private boolean isNullWindowID(String windowID) {
        return windowID == null || windowID.isEmpty() || "null".equals(windowID);
    }

    private String getWindowHandle(WebDriver driver) {
        try {
            return driver.getWindowHandle();
        }
        catch (NoSuchWindowException e) {
            return null;
        }
    }

    private String switchToWindow(WebDriver driver, String nameOrHandle) {
        try {
            driver.switchTo().window(nameOrHandle);
            return nameOrHandle;
        }
        catch (NoSuchWindowException e) {
            return null;
        }
    }

    public String selectWindow(Context context, String windowID) {
        WebDriver driver = context.getWrappedDriver();
        if (this.isNullWindowID(windowID)) {
            return this.selectPreviousWindow(context);
        }
        if ("_blank".equals(windowID)) {
            return this.selectBlankWindow(context);
        }
        KeyValue wloc = KeyValue.parse(windowID, NO_PREFIX);
        switch (wloc.getKey()) {
            case "": {
                String handle = this.switchToWindow(driver, wloc.getValue());
                if (handle != null) {
                    return handle;
                }
            }
            case "title": {
                return this.selectWindowWithTitle(context, wloc.getValue());
            }
            case "name": 
            case "handle": {
                return this.switchToWindow(driver, wloc.getValue());
            }
        }
        throw new UnsupportedOperationException(windowID);
    }

    public String selectPopUp(Context context, String windowID) {
        WebDriver driver = context.getWrappedDriver();
        if (this.isNullWindowID(windowID)) {
            Set handles = driver.getWindowHandles();
            handles.remove(context.getInitialWindowHandle());
            for (String handle : handles) {
                if (this.switchToWindow(driver, handle) == null) continue;
                return handle;
            }
            return null;
        }
        return this.selectWindow(context, windowID);
    }

    public String selectPreviousWindow(Context context) {
        String currentHandle;
        WebDriver driver = context.getWrappedDriver();
        try {
            currentHandle = this.getWindowHandle(driver);
        }
        catch (WebDriverException e) {
            currentHandle = null;
        }
        Set handles = driver.getWindowHandles();
        switch (handles.size()) {
            case 0: {
                return null;
            }
            case 1: {
                if (currentHandle == null) break;
                return currentHandle;
            }
        }
        if (currentHandle != null) {
            handles.remove(currentHandle);
        }
        if (handles.size() >= 2) {
            handles.remove(context.getInitialWindowHandle());
        }
        for (String handle : handles) {
            if (this.switchToWindow(driver, handle) == null) continue;
            return handle;
        }
        return null;
    }

    public String selectWindowWithTitle(Context context, String title) {
        WebDriver driver = context.getWrappedDriver();
        String currentHandle = this.getWindowHandle(driver);
        for (String handle : driver.getWindowHandles()) {
            if (this.switchToWindow(driver, handle) == null || !title.equals(driver.getTitle())) continue;
            return handle;
        }
        this.switchToWindow(driver, currentHandle);
        return null;
    }

    public String selectBlankWindow(Context context) {
        WebDriver driver = context.getWrappedDriver();
        String currentHandle = this.getWindowHandle(driver);
        Set handles = driver.getWindowHandles();
        handles.remove(context.getInitialWindowHandle());
        if (handles.isEmpty()) {
            return null;
        }
        for (String handle : handles) {
            String value;
            if (this.switchToWindow(driver, handle) == null || (value = (String)((JavascriptExecutor)driver).executeScript("return window.name;", new Object[0])) != null && !value.isEmpty()) continue;
            return handle;
        }
        this.switchToWindow(driver, currentHandle);
        return null;
    }

    public static void waitAfterSelectingWindowIfNeed(Context context) {
        if ("firefox".equals(context.getBrowserName())) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

