/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.utils;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Pattern;
import jp.vmi.selenium.selenese.utils.LangUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.Point;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeleniumUtils {
    private static final DecimalFormatSymbols US_FORMAT = DecimalFormatSymbols.getInstance(Locale.US);
    private static final Logger log = LoggerFactory.getLogger(SeleniumUtils.class);

    private SeleniumUtils() {
    }

    public static boolean patternMatches(String pattern, CharSequence input) {
        return new SeleniumPattern(pattern).matches(input.toString());
    }

    public static String normalizeSpaces(String str) {
        int si = str.indexOf(32);
        int ni = str.indexOf(160);
        if (si < 0 && ni < 0) {
            return str;
        }
        int len = str.length();
        StringBuilder buf = new StringBuilder(len);
        boolean skipSpc = true;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c != ' ' && c != '\u00a0') {
                buf.append(c);
                skipSpc = false;
                continue;
            }
            if (skipSpc) continue;
            buf.append(' ');
            skipSpc = true;
        }
        int blen = buf.length();
        if (blen > 0 && buf.charAt(blen - 1) == ' ') {
            buf.deleteCharAt(blen - 1);
        }
        return buf.toString();
    }

    public static String doubleToString(double d) {
        if (d % 1.0 == 0.0) {
            return new DecimalFormat("0", US_FORMAT).format(d);
        }
        return Double.toString(d);
    }

    public static <T> String convertToString(T result) {
        if (result == null) {
            return "";
        }
        if (result instanceof Object[]) {
            return LangUtils.join((CharSequence)",", Arrays.stream((Object[])result));
        }
        if (result instanceof Iterable) {
            return LangUtils.join((CharSequence)",", ((Iterable)result).iterator());
        }
        if (result instanceof Iterator) {
            return LangUtils.join((CharSequence)",", (Iterator)result);
        }
        if (result instanceof Double) {
            return SeleniumUtils.doubleToString((Double)result);
        }
        return result.toString();
    }

    public static boolean isElementNotFound(RuntimeException e) {
        return e instanceof NotFoundException || e instanceof StaleElementReferenceException || e.getCause() instanceof NotFoundException || e.getCause() instanceof StaleElementReferenceException;
    }

    private static Rectangle getWindowSafeBoundsFromEnvVars() {
        String widthStr = System.getenv("SCREEN_WIDTH");
        String heightStr = System.getenv("SCREEN_HEIGHT");
        if (widthStr == null || heightStr == null) {
            return null;
        }
        try {
            int width = Integer.parseInt(widthStr);
            int height = Integer.parseInt(heightStr);
            log.warn("Get screen size from environment variables: SCREEN_WIDTH and SCREEN_HEIGHT");
            return new Rectangle(0, 0, width, height);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Rectangle getWindowSafeBoundsFromGraphEnv() {
        GraphicsEnvironment gc = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (gc.isHeadlessInstance()) {
            return null;
        }
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        Rectangle bounds = gd.getDefaultConfiguration().getBounds();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(gd.getDefaultConfiguration());
        int x = bounds.x + insets.left;
        int y = bounds.y + insets.top;
        int width = bounds.width - (insets.left + insets.right);
        int height = bounds.height - (insets.top + insets.bottom);
        log.warn("Get screen size from grahics environment.");
        return new Rectangle(x, y, width, height);
    }

    public static void windowMaximize(WebDriver driver) {
        WebDriver.Window window = driver.manage().window();
        try {
            window.maximize();
        }
        catch (WebDriverException e) {
            String message = e.getMessage();
            if (!message.contains("failed to change window state to maximized")) {
                throw e;
            }
            log.warn("Can't maximize: {}", (Object)message);
            Rectangle bounds = SeleniumUtils.getWindowSafeBoundsFromEnvVars();
            if (bounds == null) {
                bounds = SeleniumUtils.getWindowSafeBoundsFromGraphEnv();
            }
            if (bounds == null) {
                throw e;
            }
            Point position = new Point(bounds.x, bounds.y);
            Dimension size = new Dimension(bounds.width, bounds.height);
            window.setPosition(position);
            window.setSize(size);
            log.warn("Window changed: (x, y) = {}, (width, height) = {}", (Object)position, (Object)size);
        }
    }

    public static class SeleniumPattern {
        public final Type type;
        public final Pattern regexpPattern;
        public final String stringPattern;

        public SeleniumPattern(String pattern) {
            String[] p = pattern.split(":", 2);
            if (p.length == 2) {
                String type = p[0].toLowerCase();
                if ("regexp".equals(type)) {
                    this.type = Type.REGEXP;
                    this.regexpPattern = Pattern.compile(p[1]);
                    this.stringPattern = p[1];
                    return;
                }
                if ("regexpi".equals(type)) {
                    this.type = Type.REGEXPI;
                    this.regexpPattern = Pattern.compile(p[1], 2);
                    this.stringPattern = p[1];
                    return;
                }
                if ("glob".equals(type)) {
                    pattern = p[1];
                } else if ("exact".equals(type)) {
                    this.type = Type.EXACT;
                    this.regexpPattern = null;
                    this.stringPattern = p[1];
                    return;
                }
            }
            if (pattern.indexOf(42) >= 0 || pattern.indexOf(63) >= 0) {
                int len;
                this.type = Type.GLOB;
                StringBuilder re = new StringBuilder("\\A\\Q");
                re.append(pattern.replace("*", "\\E.*\\Q").replace("?", "\\E.\\Q"));
                if (re.length() >= 6 && re.charAt(4) == '\\' && re.charAt(5) == 'E') {
                    re.delete(2, 6);
                }
                if (re.charAt((len = re.length()) - 2) == '\\' && re.charAt(len - 1) == 'Q') {
                    re.setCharAt(re.length() - 1, 'z');
                } else {
                    re.append("\\E\\z");
                }
                this.regexpPattern = Pattern.compile(re.toString(), 32);
            } else {
                this.type = Type.EXACT;
                this.regexpPattern = null;
            }
            this.stringPattern = pattern;
        }

        public boolean matches(String input) {
            input = SeleniumUtils.normalizeSpaces(input);
            switch (this.type) {
                case REGEXP: 
                case REGEXPI: 
                case GLOB: {
                    return this.regexpPattern.matcher(input).find();
                }
                case EXACT: {
                    return SeleniumUtils.normalizeSpaces(this.stringPattern).equals(input);
                }
            }
            throw new UnsupportedOperationException(this.type.toString());
        }

        public String toString() {
            return "SeleniumPattern[" + (Object)((Object)this.type) + ":" + StringEscapeUtils.escapeJava((String)this.stringPattern) + "]";
        }

        public static enum Type {
            REGEXP,
            REGEXPI,
            GLOB,
            EXACT;

        }
    }
}

