/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.log;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import jp.vmi.selenium.selenese.log.CookieFilter;
import jp.vmi.selenium.selenese.log.CookieKey;
import jp.vmi.selenium.selenese.log.CookieValue;
import org.openqa.selenium.Cookie;

public class CookieMap
extends TreeMap<CookieKey, CookieValue> {
    public void add(Cookie cookie) {
        CookieKey key = new CookieKey(cookie.getName(), cookie.getPath(), cookie.getDomain());
        CookieValue value = new CookieValue(key, cookie.getValue(), cookie.getExpiry());
        this.put(key, value);
    }

    public List<String> allMessages(CookieFilter cookieFilter) {
        ArrayList<String> list = new ArrayList<String>();
        for (CookieValue value : this.values()) {
            if (!cookieFilter.isPass(value.key.name)) continue;
            list.add(value.toString());
        }
        return list;
    }

    public List<String> diffMessages(CookieFilter cookieFilter, CookieMap prev) {
        ArrayList<String> list = new ArrayList<String>();
        for (CookieValue value : this.values()) {
            if (!cookieFilter.isPass(value.key.name)) continue;
            CookieValue prevValue = (CookieValue)prev.get(value.key);
            if (prevValue == null) {
                list.add("[add] " + value);
                continue;
            }
            if (value.equalsWithoutExpiry(prevValue)) continue;
            list.add("[mod] " + value);
        }
        for (CookieKey key : prev.keySet()) {
            if (!cookieFilter.isPass(key.name) || this.containsKey(key)) continue;
            list.add("[del] " + key);
        }
        return list;
    }
}

