/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.locator;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.vmi.selenium.selenese.locator.LocatorHandler;
import jp.vmi.selenium.selenese.utils.SeleniumUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

class NameHandler
implements LocatorHandler {
    private static final Pattern FILTER_RE = Pattern.compile("index=(\\d+)|(?:value=)?(.*)");

    NameHandler() {
    }

    @Override
    public String locatorType() {
        return "name";
    }

    @Override
    public List<WebElement> handle(WebDriver driver, String arg) {
        String[] args = arg.split("\\s+", 2);
        List result = driver.findElements(By.name((String)args[0]));
        if (result.isEmpty() || args.length == 1) {
            return result;
        }
        ArrayList<WebElement> filtered = new ArrayList<WebElement>();
        Matcher matcher = FILTER_RE.matcher(args[1]);
        matcher.matches();
        String indexString = matcher.group(1);
        if (!Strings.isNullOrEmpty((String)indexString)) {
            int index = NumberUtils.toInt((String)indexString);
            if (index < result.size()) {
                filtered.add((WebElement)result.get(index));
            }
        } else {
            String pattern = matcher.group(2);
            for (WebElement element : result) {
                try {
                    String value = element.getAttribute("value");
                    if (value == null || !SeleniumUtils.patternMatches(pattern, value)) continue;
                    filtered.add(element);
                }
                catch (StaleElementReferenceException e) {}
            }
        }
        return filtered;
    }
}

