/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.locator;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.vmi.selenium.selenese.locator.LocatorHandler;
import jp.vmi.selenium.selenese.utils.SeleniumUtils;
import jp.vmi.selenium.selenese.utils.XPathUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

class LinkHandler
implements LocatorHandler {
    LinkHandler() {
    }

    @Override
    public String locatorType() {
        return "link";
    }

    private List<WebElement> findByRegexp(WebDriver driver, By by, Pattern pattern) {
        ArrayList<WebElement> result = new ArrayList<WebElement>();
        List as = driver.findElements(by);
        for (WebElement a : as) {
            Matcher matcher;
            String text;
            block3: {
                try {
                    text = a.getText();
                    if (text != null) break block3;
                    text = "";
                }
                catch (StaleElementReferenceException e) {
                    continue;
                }
            }
            if (!(matcher = pattern.matcher(text)).find()) continue;
            result.add(a);
        }
        return result;
    }

    private List<WebElement> findByGlobString(WebDriver driver, SeleniumUtils.SeleniumPattern sp) {
        boolean and = false;
        StringBuilder xpath = new StringBuilder("//a[");
        for (String ss : sp.stringPattern.split("[*?]+")) {
            if (Strings.isNullOrEmpty((String)ss)) continue;
            if (and) {
                xpath.append(" and ");
            }
            xpath.append("contains(normalize-space(.),");
            XPathUtils.appendStringLiteral(xpath, ss);
            xpath.append(")");
            and = true;
        }
        xpath.append("]");
        By by = and ? By.xpath((String)xpath.toString()) : By.tagName((String)"a");
        return this.findByRegexp(driver, by, sp.regexpPattern);
    }

    private List<WebElement> findByExactString(WebDriver driver, SeleniumUtils.SeleniumPattern sp) {
        StringBuilder xpath = new StringBuilder("//a[normalize-space(.)=");
        XPathUtils.appendStringLiteral(xpath, sp.stringPattern);
        xpath.append(']');
        return driver.findElements(By.xpath((String)xpath.toString()));
    }

    @Override
    public List<WebElement> handle(WebDriver driver, String arg) {
        SeleniumUtils.SeleniumPattern sp = new SeleniumUtils.SeleniumPattern(arg);
        switch (sp.type) {
            case REGEXP: 
            case REGEXPI: {
                return this.findByRegexp(driver, By.tagName((String)"a"), sp.regexpPattern);
            }
            case GLOB: {
                return this.findByGlobString(driver, sp);
            }
            case EXACT: {
                return this.findByExactString(driver, sp);
            }
        }
        throw new UnsupportedOperationException(arg);
    }
}

