/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.SeleneseCommandErrorException;
import jp.vmi.selenium.selenese.command.CommandListIterator;
import jp.vmi.selenium.selenese.command.CommandSequence;
import jp.vmi.selenium.selenese.command.ICommand;
import jp.vmi.selenium.selenese.command.ILabel;
import jp.vmi.selenium.selenese.command.Screenshot;
import jp.vmi.selenium.selenese.inject.DoCommand;
import jp.vmi.selenium.selenese.result.CommandResult;
import jp.vmi.selenium.selenese.result.CommandResultList;
import jp.vmi.selenium.selenese.result.Error;
import jp.vmi.selenium.selenese.result.Result;

public class CommandList
implements Iterable<ICommand> {
    private final Map<Object, Integer> indexCache = new HashMap<Object, Integer>();
    private final List<ICommand> commandList = new ArrayList<ICommand>();
    private static final Pattern JS_BLOCK_RE = Pattern.compile("javascript\\{(.*)\\}", 32);

    public boolean isEmpty() {
        return this.commandList.isEmpty();
    }

    public int size() {
        return this.commandList.size();
    }

    public boolean add(ICommand command) {
        if (command instanceof ILabel) {
            this.indexCache.put(((ILabel)((Object)command)).getLabel(), this.commandList.size());
        }
        return this.commandList.add(command);
    }

    public int indexOf(Object key) {
        Integer index = this.indexCache.get(key);
        if (index == null) {
            index = this.commandList.indexOf(key);
            this.indexCache.put(key, index);
        }
        return index;
    }

    protected ListIterator<ICommand> originalListIterator(int index) {
        return this.commandList.listIterator(index);
    }

    public CommandListIterator iterator() {
        return this.iterator(null);
    }

    public CommandListIterator iterator(CommandListIterator parentIterator) {
        return new CommandListIterator(this, parentIterator);
    }

    @DoCommand
    protected Result doCommand(Context context, ICommand command, String ... curArgs) {
        try {
            if (context.isInteractive()) {
                System.out.println(">>> Press ENTER to continue <<<");
                System.in.read();
            }
            return command.execute(context, curArgs);
        }
        catch (SeleneseCommandErrorException e) {
            return e.getError();
        }
        catch (Exception e) {
            return new Error(e);
        }
    }

    protected void evalCurArgs(Context context, String[] curArgs) {
        for (int i = 0; i < curArgs.length; ++i) {
            Matcher matcher = JS_BLOCK_RE.matcher(curArgs[i]);
            if (!matcher.matches()) continue;
            Object value = context.getEval().eval(context, matcher.group(1));
            if (value == null) {
                value = "";
            }
            curArgs[i] = value.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Context context, CommandResultList cresultList) {
        CommandListIterator parentIterator = context.getCommandListIterator();
        CommandListIterator commandListIterator = this.iterator(parentIterator);
        context.pushCommandListIterator(commandListIterator);
        CommandSequence sequence = commandListIterator.getCommandSequence();
        boolean isContinued = true;
        try {
            while (isContinued && commandListIterator.hasNext()) {
                ICommand command = commandListIterator.next();
                sequence.increment(command);
                List<Screenshot> ss = command.getScreenshots();
                int prevSSIndex = ss == null ? 0 : ss.size();
                String[] curArgs = command.getVariableResolvedArguments(context.getCurrentTestCase().getSourceType(), context.getVarsMap());
                this.evalCurArgs(context, curArgs);
                Result result = null;
                context.resetRetries();
                while (!(result = this.doCommand(context, command, curArgs)).isSuccess() && !context.hasReachedMaxRetries()) {
                    context.incrementRetries();
                    context.waitSpeed();
                }
                if (result.isAborted()) {
                    isContinued = false;
                } else {
                    context.waitSpeed();
                }
                ss = command.getScreenshots();
                ArrayList<Screenshot> newSS = ss == null || prevSSIndex == ss.size() ? null : new ArrayList<Screenshot>(ss.subList(prevSSIndex, ss.size()));
                CommandResult cresult = new CommandResult(sequence.toString(), command, newSS, result, cresultList.getEndTime(), System.currentTimeMillis());
                cresultList.add(cresult);
            }
        }
        finally {
            context.popCommandListIterator();
        }
        return cresultList.getResult();
    }

    public String toString() {
        return this.commandList.toString();
    }
}

