/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.command;

import com.google.common.base.Strings;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.command.AbstractCommand;
import jp.vmi.selenium.selenese.command.WaitForPageToLoad;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import jp.vmi.selenium.selenese.subcommand.ISubCommand;
import jp.vmi.selenium.selenese.utils.SeleniumUtils;

public class BuiltInCommand
extends AbstractCommand {
    private final ISubCommand<?> subCommand;
    private final boolean andWait;
    private final boolean mayUpdateScreen;

    BuiltInCommand(int index, String name, String[] args, ISubCommand<?> subCommand, boolean andWait) {
        super(index, name, args, subCommand.getArgumentTypes());
        this.subCommand = subCommand;
        this.andWait = andWait;
        this.mayUpdateScreen = true;
    }

    @Override
    public boolean mayUpdateScreen() {
        return this.mayUpdateScreen;
    }

    @Override
    protected Result executeImpl(Context context, String ... curArgs) {
        String resultString = SeleniumUtils.convertToString(this.subCommand.execute(context, curArgs));
        if (this.andWait) {
            int timeout = context.getTimeout();
            WaitForPageToLoad.execute(context, timeout);
        }
        return Strings.isNullOrEmpty((String)resultString) ? Success.SUCCESS : new Success(resultString);
    }

    @Override
    public int getArgumentCount() {
        return this.subCommand.getArgumentCount();
    }
}

