/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese;

import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.vmi.selenium.selenese.utils.EscapeUtils;
import jp.vmi.selenium.selenese.utils.SeleniumUtils;
import org.openqa.selenium.Keys;

public class VarsMap
extends HashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    private static final Pattern SCRIPT_RE = Pattern.compile("(?<quote>[\"'`]?)\\$\\{(?<name>\\w+)\\}\\k<quote>", 32);
    private static final Pattern STRING_RE = Pattern.compile("\\$\\{(?<name>.+?)\\}", 32);

    public VarsMap() {
        this.put("space", " ");
        this.put("nbsp", "\u00a0");
        for (Keys key : Keys.values()) {
            this.put("KEY_" + key.name(), key.toString());
        }
        this.sendKeysAliases(Keys.BACK_SPACE, "BACKSPACE", "BKSP");
        this.sendKeysAliases(Keys.CONTROL, "CTRL");
        this.sendKeysAliases(Keys.ESCAPE, "ESC");
        this.sendKeysAliases(Keys.PAGE_UP, "PGUP");
        this.sendKeysAliases(Keys.PAGE_DOWN, "PGDN");
        this.sendKeysAliases(Keys.INSERT, "INS");
        this.sendKeysAliases(Keys.DELETE, "DEL");
        this.sendKeysAliases(Keys.NUMPAD0, "N0");
        this.sendKeysAliases(Keys.NUMPAD1, "N1");
        this.sendKeysAliases(Keys.NUMPAD2, "N2");
        this.sendKeysAliases(Keys.NUMPAD3, "N3");
        this.sendKeysAliases(Keys.NUMPAD4, "N4");
        this.sendKeysAliases(Keys.NUMPAD5, "N5");
        this.sendKeysAliases(Keys.NUMPAD6, "N6");
        this.sendKeysAliases(Keys.NUMPAD7, "N7");
        this.sendKeysAliases(Keys.NUMPAD8, "N8");
        this.sendKeysAliases(Keys.NUMPAD9, "N9");
        this.sendKeysAliases(Keys.MULTIPLY, "MUL");
        this.sendKeysAliases(Keys.ADD, "PLUS");
        this.sendKeysAliases(Keys.SEPARATOR, "SEP");
        this.sendKeysAliases(Keys.SUBTRACT, "MINUS");
        this.sendKeysAliases(Keys.DECIMAL, "PERIOD");
        this.sendKeysAliases(Keys.DIVIDE, "DIV");
    }

    private void sendKeysAliases(Keys keys, String ... aliases) {
        for (String alias : aliases) {
            this.put("KEY_" + alias, keys.toString());
        }
    }

    @Deprecated
    public String replaceVars(String expr) {
        return this.replaceVars(false, expr);
    }

    public String replaceVars(boolean isScript, String expr) {
        if (!expr.contains("${")) {
            return expr;
        }
        StringBuilder result = new StringBuilder();
        Pattern re = isScript ? SCRIPT_RE : STRING_RE;
        Matcher matcher = re.matcher(expr);
        int prevEnd = 0;
        while (matcher.find(prevEnd)) {
            int nextStart = matcher.start();
            if (prevEnd < nextStart) {
                result.append(expr.substring(prevEnd, nextStart));
            }
            String name = matcher.group("name");
            Object rawValue = this.get(name);
            String value = SeleniumUtils.convertToString(rawValue);
            if (isScript) {
                if (rawValue == null) {
                    result.append("null");
                } else if (rawValue instanceof Number || rawValue instanceof Boolean) {
                    result.append(rawValue);
                } else {
                    result.append('\"').append(EscapeUtils.escapeJSString(value)).append('\"');
                }
            } else {
                result.append(value);
            }
            prevEnd = matcher.end();
        }
        if (prevEnd < expr.length()) {
            result.append(expr.substring(prevEnd));
        }
        return result.toString();
    }

    @Deprecated
    public String[] replaceVarsForArray(String[] exprs) {
        String[] result = new String[exprs.length];
        for (int i = 0; i < exprs.length; ++i) {
            result[i] = this.replaceVars(exprs[i]);
        }
        return result;
    }
}

