/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese;

import java.util.ArrayList;
import java.util.List;
import jp.vmi.html.result.IHtmlResultTestSuite;
import jp.vmi.junit.result.ITestSuite;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.ITreedFileGenerator;
import jp.vmi.selenium.selenese.InvalidSeleneseException;
import jp.vmi.selenium.selenese.Parser;
import jp.vmi.selenium.selenese.Selenese;
import jp.vmi.selenium.selenese.command.ICommandFactory;
import jp.vmi.selenium.selenese.inject.ExecuteTestSuite;
import jp.vmi.selenium.selenese.log.PageInformation;
import jp.vmi.selenium.selenese.result.Error;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Unexecuted;
import jp.vmi.selenium.selenese.utils.PathUtils;
import jp.vmi.selenium.selenese.utils.StopWatch;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSuite
implements Selenese,
ITreedFileGenerator,
ITestSuite,
IHtmlResultTestSuite {
    private static final Logger log = LoggerFactory.getLogger(TestSuite.class);
    private ITreedFileGenerator parent = null;
    private int index = 0;
    private String filename = null;
    private String baseName = null;
    private String name = null;
    private String parentDir = null;
    private String webDriverName = null;
    private final List<Selenese> seleneseList = new ArrayList<Selenese>();
    private final StopWatch stopWatch = new StopWatch();
    private Result result = Unexecuted.UNEXECUTED;

    public TestSuite initialize(String filename, String name) {
        String baseName;
        if ((filename = PathUtils.normalize(filename)) != null) {
            baseName = FilenameUtils.getBaseName((String)filename);
            this.parentDir = FilenameUtils.getFullPathNoEndSeparator((String)filename);
        } else {
            baseName = name;
        }
        if (name == null) {
            name = baseName;
        }
        this.filename = filename;
        this.baseName = baseName;
        this.name = name;
        return this;
    }

    @Override
    public ITreedFileGenerator getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ITreedFileGenerator parent) {
        this.parent = parent;
    }

    @Override
    public Selenese.Type getType() {
        return Selenese.Type.TEST_SUITE;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    public String getWebDriverName() {
        return this.webDriverName;
    }

    public void setWebDriverName(String webDriverName) {
        this.webDriverName = webDriverName;
    }

    public void addSelenese(Selenese selenese) {
        if (selenese instanceof ITreedFileGenerator) {
            ITreedFileGenerator tfg = (ITreedFileGenerator)((Object)selenese);
            tfg.setParent(this);
            tfg.setIndex(this.seleneseList.size() + 1);
        }
        this.seleneseList.add(selenese);
    }

    public void addSeleneseFile(String filename, ICommandFactory commandFactory) {
        filename = FilenameUtils.getPrefixLength((String)filename) == 0 && this.parentDir != null ? PathUtils.concat(this.parentDir, filename) : PathUtils.normalize(filename);
        this.addSelenese(Parser.parse(filename, commandFactory));
    }

    public List<Selenese> getSeleneseList() {
        return this.seleneseList;
    }

    @Override
    public StopWatch getStopWatch() {
        return this.stopWatch;
    }

    @Override
    public Result getResult() {
        return this.result;
    }

    @Override
    @ExecuteTestSuite
    public Result execute(Selenese parent, Context context) {
        context.prepareWebDriver();
        context.setLatestPageInformation(PageInformation.EMPTY);
        context.resetSpeed();
        for (Selenese selenese : this.seleneseList) {
            Result r;
            try {
                r = selenese.execute(this, context);
            }
            catch (RuntimeException e) {
                String msg = e.getMessage();
                this.result = new Error(msg);
                log.error(msg);
                throw e;
            }
            catch (InvalidSeleneseException e) {
                r = new Error(e);
            }
            this.result = this.result.updateWithChildResult(selenese, r);
        }
        return this.result;
    }

    protected String toStringImpl(String className) {
        StringBuilder s = new StringBuilder(className).append('[').append(this.name).append(']');
        if (this.filename != null) {
            s.append(" (").append(this.filename).append(')');
        }
        return s.toString();
    }

    public String toString() {
        return this.toStringImpl("TestSuite");
    }
}

