/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Function;
import jp.vmi.html.result.IHtmlResultTestCase;
import jp.vmi.junit.result.ITestCase;
import jp.vmi.selenium.selenese.Context;
import jp.vmi.selenium.selenese.Selenese;
import jp.vmi.selenium.selenese.SeleneseRunnerRuntimeException;
import jp.vmi.selenium.selenese.SourceType;
import jp.vmi.selenium.selenese.command.BlockEnd;
import jp.vmi.selenium.selenese.command.BlockStart;
import jp.vmi.selenium.selenese.command.CommandList;
import jp.vmi.selenium.selenese.command.ICommand;
import jp.vmi.selenium.selenese.command.ICommandFactory;
import jp.vmi.selenium.selenese.inject.Binder;
import jp.vmi.selenium.selenese.inject.ExecuteTestCase;
import jp.vmi.selenium.selenese.result.CommandResultList;
import jp.vmi.selenium.selenese.result.Result;
import jp.vmi.selenium.selenese.result.Success;
import jp.vmi.selenium.selenese.utils.LogRecorder;
import jp.vmi.selenium.selenese.utils.PathUtils;
import jp.vmi.selenium.selenese.utils.StopWatch;
import org.apache.commons.io.FilenameUtils;

public class TestCase
implements Selenese,
ITestCase,
IHtmlResultTestCase {
    private SourceType sourceType = SourceType.SELENESE;
    private String filename = null;
    private String baseName = null;
    private String name = null;
    private String baseURL = null;
    private BlockStart currentBlockStart = BlockStart.NO_BLOCK_START;
    private final Deque<BlockStart> blockStack = new ArrayDeque<BlockStart>();
    private final CommandList commandList = Binder.newCommandList();
    private final CommandResultList cresultList = new CommandResultList();
    private final StopWatch stopWatch = new StopWatch();
    private LogRecorder logRecorder = null;
    private boolean hasNativeAlertHandler = false;

    public TestCase initialize(SourceType sourceType, String filename, String name, String baseURL) {
        String baseName;
        String string = baseName = (filename = PathUtils.normalize(filename)) != null ? FilenameUtils.getBaseName((String)filename) : name;
        if (name == null) {
            name = baseName;
        }
        this.sourceType = sourceType;
        this.filename = filename;
        this.baseName = baseName;
        this.name = name;
        this.baseURL = baseURL.replaceFirst("/+$", "");
        return this;
    }

    @Override
    public Selenese.Type getType() {
        return Selenese.Type.TEST_CASE;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    @Override
    public CommandList getCommandList() {
        return this.commandList;
    }

    @Override
    public StopWatch getStopWatch() {
        return this.stopWatch;
    }

    @Override
    public void setLogRecorder(LogRecorder logRecorder) {
        if (this.logRecorder != null) {
            throw new SeleneseRunnerRuntimeException("The log recorder of " + this + " is already set.");
        }
        this.logRecorder = logRecorder;
    }

    @Override
    public LogRecorder getLogRecorder() {
        return this.logRecorder;
    }

    @Override
    public Result getResult() {
        return this.cresultList.getResult();
    }

    @Override
    public CommandResultList getResultList() {
        return this.cresultList;
    }

    public boolean hasNativeAlertHandler() {
        return this.hasNativeAlertHandler;
    }

    public void addCommand(ICommand command) {
        command.setBlockStart(this.currentBlockStart);
        if (command instanceof BlockEnd) {
            this.currentBlockStart.setBlockEnd((BlockEnd)((Object)command));
            this.currentBlockStart = this.blockStack.pop();
        }
        if (command instanceof BlockStart) {
            this.blockStack.push(this.currentBlockStart);
            this.currentBlockStart = (BlockStart)((Object)command);
        }
        this.commandList.add(command);
        this.hasNativeAlertHandler |= command.isNativeAlertHandler();
    }

    public final void addCommand(Function<Integer, ICommand> cmdGenFunc) {
        int index = this.commandList.size() + 1;
        ICommand command = cmdGenFunc.apply(index);
        this.addCommand(command);
    }

    public final void addCommand(ICommandFactory commandFactory, String name, String ... args) {
        this.addCommand((Integer index) -> commandFactory.newCommand((int)index, name, args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ExecuteTestCase
    public Result execute(Selenese parent, Context context) {
        if (this.commandList.isEmpty()) {
            return this.cresultList.setResult(Success.SUCCESS);
        }
        if (parent instanceof TestCase) {
            try {
                context.setCurrentTestCase(this);
                Result result = this.commandList.execute(context, ((TestCase)parent).getResultList());
                return result;
            }
            finally {
                context.setCurrentTestCase((TestCase)parent);
            }
        }
        context.setCurrentTestCase(this);
        context.resetState();
        this.cresultList.setEndTime(System.currentTimeMillis());
        return this.commandList.execute(context, this.cresultList);
    }

    public String toString() {
        StringBuilder s = new StringBuilder("TestCase[").append(this.name).append("]");
        if (this.filename != null) {
            s.append(" (").append(this.filename).append(")");
        }
        return s.toString();
    }
}

