/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.junit.result;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import jp.vmi.junit.result.FailsafeSummary;
import jp.vmi.junit.result.ITestCase;
import jp.vmi.junit.result.ITestSuite;
import jp.vmi.junit.result.ITestTarget;
import jp.vmi.junit.result.ObjectFactory;
import jp.vmi.junit.result.TestCaseResult;
import jp.vmi.junit.result.TestResult;
import jp.vmi.junit.result.TestSuiteResult;
import jp.vmi.selenium.selenese.utils.CommandLineUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JUnitResult {
    private static final Logger log = LoggerFactory.getLogger(JUnitResult.class);
    public static final String FAILSAFE_SUMMARY_FILENAME = "failsafe-summary.xml";
    private static final String[] PROP_NAMES = new String[]{"java.vm.name", "java.version", "os.name", "os.version", "os.arch", "user.language", "user.country", "user.timezone"};
    private String[] commandLineArgs = null;
    private String xmlResultDir = null;
    private final JAXBContext context = this.initContext();
    private final Map<Object, TestResult<?>> map = new ConcurrentHashMap();
    private final FailsafeSummary failsafeSummary = ObjectFactory.factory.createFailsafeSummary();

    private JAXBContext initContext() {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public void setCommandLineArgs(String[] args) {
        this.commandLineArgs = args;
    }

    public void setDir(String dir) {
        this.xmlResultDir = dir;
    }

    protected void mkdirs() {
        File dir = new File(this.xmlResultDir);
        if (!dir.exists()) {
            dir.mkdirs();
            log.info("Make the directory for XML result: {}", (Object)dir);
        }
    }

    public void startTestSuite(ITestSuite testSuite) {
        TestSuiteResult suiteResult = ObjectFactory.factory.createTestSuiteResult(testSuite);
        for (String propName : PROP_NAMES) {
            suiteResult.addProperty(propName, System.getProperty(propName, "<UNKNOWN>"));
        }
        if (this.commandLineArgs != null) {
            suiteResult.addProperty("seleneseRunner.args", CommandLineUtils.espaceCommandLineArgs(this.commandLineArgs));
        }
        this.map.put(testSuite, suiteResult);
    }

    public void endTestSuite(ITestSuite testSuite) {
        TestSuiteResult suiteResult = (TestSuiteResult)this.map.remove(testSuite);
        if (this.xmlResultDir == null || suiteResult.getTests() == 0) {
            return;
        }
        try {
            Marshaller marshaller = this.context.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            this.mkdirs();
            File file = new File(this.xmlResultDir, testSuite.getFileBaseName("xml"));
            marshaller.marshal((Object)suiteResult, file);
            log.info("Generated JUnit result: {}", (Object)file);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public void addProperty(ITestSuite testSuite, String name, String value) {
        TestSuiteResult suiteResult = (TestSuiteResult)this.map.get(testSuite);
        suiteResult.addProperty(name, value);
    }

    public void startTestCase(ITestTarget testTarget, ITestCase testCase) {
        TestCaseResult caseResult = ObjectFactory.factory.createTestCaseResult(testCase);
        this.map.put(testCase, caseResult);
        if (testTarget != null && testTarget instanceof ITestSuite) {
            TestSuiteResult suiteResult = (TestSuiteResult)this.map.get(testTarget);
            suiteResult.addTestCaseResult(caseResult);
        }
    }

    public void endTestCase(ITestCase testCase) {
        TestCaseResult caseResult = (TestCaseResult)this.map.remove(testCase);
        this.failsafeSummary.skipped += caseResult.getSkipped().intValue();
    }

    public void setSuccess(ITestCase testCase) {
        TestCaseResult caseResult = (TestCaseResult)this.map.get(testCase);
        caseResult.setSuccess();
        ++this.failsafeSummary.completed;
    }

    public void setError(ITestCase testCase, String message, String trace) {
        TestCaseResult caseResult = (TestCaseResult)this.map.get(testCase);
        caseResult.setError(message, trace);
        ++this.failsafeSummary.completed;
        ++this.failsafeSummary.errors;
    }

    public void setFailure(ITestCase testCase, String message, String trace) {
        TestCaseResult caseResult = (TestCaseResult)this.map.get(testCase);
        caseResult.setFailure(message, trace);
        ++this.failsafeSummary.completed;
        ++this.failsafeSummary.failures;
    }

    public void generateFailsafeSummary() {
        if (this.xmlResultDir == null) {
            return;
        }
        try {
            Marshaller marshaller = this.context.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            this.mkdirs();
            File file = new File(this.xmlResultDir, FAILSAFE_SUMMARY_FILENAME);
            marshaller.marshal((Object)this.failsafeSummary, file);
            log.info("Generated failsafe summary: {}", (Object)file);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

