/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.webdriver;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import jp.vmi.selenium.selenese.config.DefaultConfig;
import jp.vmi.selenium.selenese.config.IConfig;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;

public class DriverOptions {
    private final IdentityHashMap<DriverOption, String> map = Maps.newIdentityHashMap();
    private final DesiredCapabilities caps = new DesiredCapabilities();
    private String[] cliArgs = ArrayUtils.EMPTY_STRING_ARRAY;
    private List<File> chromeExtensions = new ArrayList<File>();
    private final HashMap<String, String> envVars = Maps.newHashMap();
    private static final Comparator<Map.Entry<String, ?>> mapEntryComparator = new Comparator<Map.Entry<String, ?>>(){

        @Override
        public int compare(Map.Entry<String, ?> e1, Map.Entry<String, ?> e2) {
            return e1.getKey().compareTo(e2.getKey());
        }
    };

    public DriverOptions() {
    }

    @Deprecated
    public DriverOptions(CommandLine cli) {
        this(new DefaultConfig(cli));
    }

    public DriverOptions(IConfig config) {
        block5: for (DriverOption opt : DriverOption.values()) {
            String key = opt.name().toLowerCase().replace('_', '-');
            switch (opt) {
                case DEFINE: {
                    this.addDefinitions(config.getOptionValues("define"));
                    continue block5;
                }
                case CLI_ARGS: {
                    if (!config.hasOption(key)) continue block5;
                    this.cliArgs = config.getOptionValues(key);
                    continue block5;
                }
                case CHROME_EXTENSION: {
                    if (!config.hasOption(key)) continue block5;
                    for (String ext : config.getOptionValues(key)) {
                        this.chromeExtensions.add(new File(ext));
                    }
                    continue block5;
                }
                default: {
                    this.set(opt, config.getOptionValue(key));
                }
            }
        }
    }

    public DriverOptions(DriverOptions other) {
        this.map.putAll(other.map);
        this.caps.merge((Capabilities)other.caps);
        this.cliArgs = other.cliArgs;
        this.chromeExtensions = other.chromeExtensions;
        this.envVars.putAll(other.envVars);
    }

    public String get(DriverOption opt) {
        switch (opt) {
            case DEFINE: {
                throw new IllegalArgumentException("Need to use DriverOptions#getCapabilities() instead of get(DriverOption.DEFINE).");
            }
            case CLI_ARGS: {
                throw new IllegalArgumentException("Need to use DriverOptions#getExtraOptions() instead of get(DriverOption.CLI_ARGS).");
            }
            case CHROME_EXTENSION: {
                throw new IllegalArgumentException("Need to use DriverOptions#getExtraOptions() instead of get(DriverOption.CHROME_EXTENSION).");
            }
        }
        return this.map.get((Object)opt);
    }

    public boolean has(DriverOption opt) {
        switch (opt) {
            case DEFINE: {
                return !this.caps.asMap().isEmpty();
            }
            case CLI_ARGS: {
                return this.cliArgs.length != 0;
            }
            case CHROME_EXTENSION: {
                return !this.chromeExtensions.isEmpty();
            }
        }
        return this.map.containsKey((Object)opt);
    }

    public DriverOptions set(DriverOption opt, String ... values) {
        switch (opt) {
            case DEFINE: {
                this.addDefinitions(values);
                break;
            }
            case CLI_ARGS: {
                this.cliArgs = (String[])ArrayUtils.addAll((Object[])this.cliArgs, (Object[])values);
                break;
            }
            case CHROME_EXTENSION: {
                for (String ext : values) {
                    this.chromeExtensions.add(new File(ext));
                }
                break;
            }
            default: {
                if (values.length != 1) {
                    throw new IllegalArgumentException("Need to pass only a single value for " + (Object)((Object)opt));
                }
                if (values[0] != null) {
                    this.map.put(opt, values[0]);
                    break;
                }
                this.map.remove((Object)opt);
            }
        }
        return this;
    }

    public DriverOptions addDefinitions(String ... defs) {
        if (defs == null) {
            return this;
        }
        for (String def : defs) {
            String capValue;
            String capName;
            String[] pair;
            if (def.contains("+=")) {
                pair = def.split("\\+=", 2);
                capName = pair[0];
                capValue = pair[1];
                Object prevCapValue = this.caps.getCapability(capName);
                if (prevCapValue == null) {
                    this.caps.setCapability(capName, (Object)new String[]{capValue});
                    continue;
                }
                if (prevCapValue instanceof String) {
                    this.caps.setCapability(capName, (Object)new String[]{(String)prevCapValue, capValue});
                    continue;
                }
                if (prevCapValue instanceof String[]) {
                    this.caps.setCapability(capName, (Object)ArrayUtils.add((Object[])((String[])prevCapValue), (Object)capValue));
                    continue;
                }
                throw new IllegalArgumentException("The capability " + capName + " is not string.");
            }
            if (def.contains("=")) {
                pair = def.split("=", 2);
                capName = pair[0];
                capValue = pair[1];
                this.caps.setCapability(capName, capValue);
                continue;
            }
            throw new IllegalArgumentException("The definition format need to be KEY=VALUE or KEY+=VALUE: " + def);
        }
        return this;
    }

    public String[] getCliArgs() {
        return this.cliArgs;
    }

    public List<File> getChromeExtensions() {
        return this.chromeExtensions;
    }

    public Map<String, String> getEnvVars() {
        return this.envVars;
    }

    public String toString() {
        Map capsMap;
        StringBuilder result = new StringBuilder("[");
        String sep = "";
        if (!this.map.isEmpty()) {
            block5: for (DriverOption driverOption : DriverOption.values()) {
                switch (driverOption) {
                    case DEFINE: {
                        continue block5;
                    }
                    case CLI_ARGS: {
                        if (this.cliArgs.length == 0) continue block5;
                        result.append(driverOption.name()).append('=');
                        for (String extraOption : this.cliArgs) {
                            result.append(extraOption).append(',');
                        }
                        result.setCharAt(result.length() - 1, '|');
                        continue block5;
                    }
                    case CHROME_EXTENSION: {
                        if (this.chromeExtensions.isEmpty()) continue block5;
                        result.append(driverOption.name()).append('=');
                        for (File extraOption : this.chromeExtensions) {
                            result.append(extraOption.toString()).append(',');
                        }
                        result.setCharAt(result.length() - 1, '|');
                        continue block5;
                    }
                    default: {
                        if (!this.map.containsKey((Object)driverOption)) continue block5;
                        result.append(driverOption.name()).append('=').append(this.map.get((Object)driverOption)).append('|');
                    }
                }
            }
            result.deleteCharAt(result.length() - 1);
            sep = "|";
        }
        if (!(capsMap = this.caps.asMap()).isEmpty()) {
            result.append(sep).append("DEFINE=[\n");
            ArrayList capsList = new ArrayList(capsMap.entrySet());
            Collections.sort(capsList, mapEntryComparator);
            for (Map.Entry entry : capsList) {
                Object value = entry.getValue();
                if (value instanceof Object[]) {
                    value = StringUtils.join((Object[])((Object[])value), (String)", ");
                }
                result.append("  ").append((String)entry.getKey()).append('=').append(value).append("\n");
            }
            result.append(']');
            sep = "|";
        }
        if (!this.envVars.isEmpty()) {
            result.append(sep).append("ENV_VARS=[\n");
            ArrayList<Map.Entry<String, String>> envVarsList = new ArrayList<Map.Entry<String, String>>(this.envVars.entrySet());
            Collections.sort(envVarsList, mapEntryComparator);
            for (Map.Entry entry : envVarsList) {
                result.append("  ").append((String)entry.getKey()).append('=').append((String)entry.getValue()).append("\n");
            }
            result.append(']');
        }
        result.append(']');
        return result.toString();
    }

    public DesiredCapabilities getCapabilities() {
        return this.caps;
    }

    public static enum DriverOption {
        PROFILE,
        PROFILE_DIR,
        PROXY,
        PROXY_USER,
        PROXY_PASSWORD,
        NO_PROXY,
        FIREFOX,
        CHROMEDRIVER,
        IEDRIVER,
        PHANTOMJS,
        REMOTE_PLATFORM,
        REMOTE_BROWSER,
        REMOTE_VERSION,
        REMOTE_URL,
        WIDTH,
        HEIGHT,
        DEFINE,
        CLI_ARGS,
        CHROME_EXTENSION,
        CHROME_EXPERIMENTAL_OPTIONS;

    }
}

