/*
 * Decompiled with CFR 0.152.
 */
package jp.vmi.selenium.selenese.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public class SystemInformation {
    private static final String UNKNOWN = "<unknown>";
    private static SystemInformation systemInformation = new SystemInformation();

    public static SystemInformation getInstance() {
        return systemInformation;
    }

    private SystemInformation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getVersionFromPomProperties(String pomProps) {
        InputStream is = null;
        try {
            is = SystemInformation.class.getResourceAsStream(pomProps);
            if (is == null) {
                String string = UNKNOWN;
                return string;
            }
            Properties prop = new Properties();
            prop.load(is);
            String string = prop.getProperty("version", UNKNOWN);
            return string;
        }
        catch (IOException e) {
            String string = UNKNOWN;
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public String getSeleneseRunnerVersion() {
        return SystemInformation.getVersionFromPomProperties("/META-INF/maven/jp.vmi/selenese-runner-java/pom.properties");
    }

    public String getSeleniumVersion() {
        return SystemInformation.getVersionFromPomProperties("/META-INF/maven/org.seleniumhq.selenium/selenium-java/pom.properties");
    }

    public String getJavaVMName() {
        return System.getProperty("java.vm.name", UNKNOWN);
    }

    public String getJavaVersion() {
        return System.getProperty("java.version", UNKNOWN);
    }

    public String getOperatingSystem() {
        return String.format("%s %s (%s)", System.getProperty("os.name", UNKNOWN), System.getProperty("os.version", UNKNOWN), System.getProperty("os.arch", UNKNOWN));
    }

    public String getLanguage() {
        return System.getProperty("user.language", UNKNOWN);
    }

    public String getCountry() {
        return System.getProperty("user.country", UNKNOWN);
    }

    public String getTimeZone() {
        return System.getProperty("user.timezone", UNKNOWN);
    }
}

